package JCL;

import utils.*;
import java.util.Vector;
import java.io.PrintStream;
import java.awt.*;

/**
 * Default solution manager.
 *
 * @author Marc Torrens
 */

public class MySolutionManager implements SolutionManagerInterface {
  
  Vector v;
  int number;
  
  Network net;
  Solver solver;
  SolutionAttributes attributes;
  
  boolean int_html;
  boolean final_html;
  boolean int_console;
  boolean final_console;
  
  Work work;
  
  int enters = 0;
  int leaves = 0;
  int insts = 0;
  int checks = 0;
  
  /**
    *	Create a new default solution manager.
    */
 
  public MySolutionManager ( Work wk ) {
	work = wk;
  }
 
 
 
  
  /**
    *	Notify that a solving is beginning.
    */

  public void NotifyStart (Network net, Solver solver, SolutionAttributes attributes) {

    this.net = net;
    this.solver = solver;
    this.attributes = attributes;
    
    //	Initialize the variables
    
    v = new Vector ();
    number = 0;
    
    //	Put the attributes in the beginning, in the case there is no solution
    
    v.addElement (attributes);
  }




  /*
   *	Display the attributes part of a solution.
   */

  private void DisplayAttributesPart (SolutionAttributes attr) {
    PrintStream out = System.out;
    
    out.println ("Network attributes :");
    out.println ("  Network name   : " + attr.network_name);
    out.println ("  Network author : " + attr.network_author);
    out.println ("  Algorithm      : " + attr.algorithm);
  }



  
  /*
   *	Display the solution part.
   */
  
  private void DisplaySolutionPart (Solution solution) {
	  
    String s = "";
    
    for (int i = 0; i < net.GetSize(); i++)
      s += "  " + net.GetVariable(i).GetName() + " : " + 
	net.GetVariable(i).GetDomain().GetValueName(solution.values[i]) + "\n";
    System.out.println (s);
    
  }


  /**
    *	Enter a new recursion level.
    */
  
  public void NotifyEnterLevel (){
    enters++;
  }
  
  
  
  
    /**
    *	Leave a recursion level.
    */
  
  public void NotifyLeaveLevel () {
    leaves++;
    }
  
  
 
  
  
  
   /**
  * Count the leaves in backjumping algorithms.
  **/
  
  public void NotifyBackjump()
  {
  		leaves ++;
  } 
  
  
  
  
  
    /**
    *	Instanciate a variable.
    */
  
  public void NotifyInstanciation () {
    insts++; 
  }
  
 
  
  
    /**
    *	Do a consistency check.
    */
  
  public void NotifyConsistencyCheck () {
    checks++;
  }
  
    
 
  
  /**
    *	Notify the solution manager that a new solution has been found.
    */
  
  public void NotifySolution (Solution solution) {
    
    //	Add the solution

    number++;
    v.addElement (solution);
    
    //	Display to the console
    
    //  if (int_console) {
    //       DisplayAttributesPart (solution.GetAttributes ());
    //       System.out.println ("Solution " + Integer.toString (number) + " :");
    // 			DisplaySolutionPart (solution);
    //     }
    
    //	Display in an HTML document
    //  
    //     if ((intf != null) && (int_html))
    //       intf.DisplaySolutionCallback (solution, net);
    
   
   	// Aditional code :
   	
		for (int i = 0; i < net.GetSize(); i++)
		{
			String strRes = net.GetVariable(i).GetDomain().GetValueName(solution.values[i]);
			int indRes = work.IndexOfResource( strRes );
			work.GetTask( i ).SetAlocatedResource( indRes );
		} 			
 
	 	work.GetDessin().repaint();
     
  } 




  /**
    *	Notify the solution manager that the solving is ending.
    *
    *	This will print a summary of all the solutions found.
    */

  public void NotifyEnd () {
    
    //	Display to the console
    
/*
    System.out.println ("Number of solutions found : " + Integer.toString (number));
    System.out.println ();
    DisplayAttributesPart (attributes);
    
    for (int i = 1; i <= number; i++) {
      System.out.println ("Solution " + Integer.toString (i) + " :");
      DisplaySolutionPart ((Solution)(v.elementAt (i)));
    }
*/    
    	// Aditional code :
    	
    	work.GetInfo().AppendDetails( "\nNumber of solutions found : " + number );   	
    	
    work.GetInfo().AppendDetails( "\n" );
    work.GetInfo().AppendDetails( "Number of enters         : " + (enters-1) );
    work.GetInfo().AppendDetails( "Number of backtracks     : " + leaves );
    work.GetInfo().AppendDetails( "Number of instantiations : " + insts );
    work.GetInfo().AppendDetails( "Number of checks         : " + checks );

    	
		// Placer le panneau de controle dans l'etat 1
		work.GetControl().IntoState( 1 );
    
  }
}
