package JCL;

/**
 * Representation of a constraint between two variables
 * for the Java Constraint Library.
 *
 * @author Erik Bruchez
 * @version Last update 19-11-96
 */

public class Constraint {
	

	Variable v1, v2;
	Domain d1, d2;
	int s1, s2;
	
	boolean isExplicit = true;

	boolean matrix[][];

	/*
	 *	Constructors.
	 */

	public Constraint () {
		this.isExplicit = true;
	}

	public Constraint (Variable v1, Variable v2) {
		SetVariables (v1, v2);
		this.isExplicit = true;
	}
	public void SetImplicitConstraint () {
		this.isExplicit = false;
	}
	
	public void SetExplicitConstraint () {
		this.isExplicit = true;
	}
	
	public boolean IsExplicit () {
		return this.isExplicit;
	}
	/**
	 *	Set the variables associated with the constraint
	 *	and initialize the constraint matrix.
	 */
	
	public void SetVariables (Variable v1, Variable v2) {
		this.v1 = v1;
		this.v2 = v2;

		d1 = v1.GetDomain ();
		d2 = v2.GetDomain ();

		s1 = d1.GetSize ();
		s2 = d2.GetSize ();

		InitializeMatrix ();
	}
	
	private void InitializeMatrix () {
		matrix = new boolean[s1][s2];
		ClearAllConstraints ();
	}

	/**
	 *	Get the first variable associated with the constraint.
	 */

	public Variable GetFirstVariable () {
		return v1;
	}

	/**
	 *	Get the second variable associated with the constraint.
	 */

	public Variable GetSecondVariable () {
		return v2;
	}
	
	/**
	 *	Clear all the constraints between the two variables.
	 */
	
	public void ClearAllConstraints () {
		for (int i = 0; i < s1; i++)
			for (int j = 0; j < s2; j++)
				matrix[i][j] = false;
	}
	
	/**
	 *	Set all the constraints between the two variables.
	 */
	
	public void SetAllConstraints () {
		for (int i = 0; i < s1; i++)
			for (int j = 0; j < s2; j++)
				matrix[i][j] = true;
	}
	
	/**
	 *	Set a constraint between the two variables for the
	 *	given value indexes.
	 */
	
	public void SetConstraint (int vindex1, int vindex2) {
		if ( (vindex1 < s1) && (vindex2 < s2) ) {
			matrix[vindex1][vindex2] = true;
		} else {
			throw new UndefinedValueException ();
		}
	}
	
	/**
	 *	Set a constraint beween the two variables for the
	 *	given value names.
	 */
	
	public void SetConstraint (String vname1, String vname2) {
		int vindex1 = d1.GetValueIndex (vname1);
		int vindex2 = d2.GetValueIndex (vname2);

		SetConstraint (vindex1, vindex2);
	}

	/**
	 *	Clear a constraint between the two variables for the
	 *	given value indexes.
	 */
	
	public void ClearConstraint (int vindex1, int vindex2) {
		if ( (vindex1 < s1) && (vindex2 < s2) ) {
			matrix[vindex1][vindex2] = false;
		} else {
			throw new UndefinedValueException ();
		}
	}

	/**
	 *	Clear a constraint beween the two variables for the
	 *	given value names.
	 */

	public void ClearConstraint (String vname1, String vname2) {
		int vindex1 = d1.GetValueIndex (vname1);
		int vindex2 = d2.GetValueIndex (vname2);

		ClearConstraint (vindex1, vindex2);
	}

	/**
	 *	Get the constraint between the two variables for the given
	 *	value indexes.
	 */

	public final boolean GetConstraint (int vindex1, int vindex2) {
		String s1, s2;
		s1 = v1.name;
		s2 = v2.name;

		
		if ((vindex1 == vindex2) && (s1.equals (s2))) {
			//	Always is true
			return true;
		} else {
			if (this.isExplicit) {
				return matrix[vindex1][vindex2];
			} else {
				return true;
			}
		}
	}

	/**
	 *	Get the constraint between the two variables for the given
	 *	value names.
	 */

	public final boolean GetConstraint (String vname1, String vname2) {
		int vindex1 = d1.GetValueIndex (vname1);
		int vindex2 = d2.GetValueIndex (vname2);

		return GetConstraint (vindex1, vindex2);
	}
}
