package JCL;

/**
 * Implementation of a simple BackTracking solver for the Java
 * Constraint Library.
 *
 * @author Erik Bruchez
 */

public class BTSolver extends Solver {
	
	boolean found = false;
	int count = 0;

	final static String NAME = "Simple Backtracking";
	
	/*
	 *	Constructors.
	 */

	public BTSolver () {
	}

	public BTSolver (Network net) {
		SetNetwork (net);
	}

	/**
	 *	Return the name of the algorithm.
	 */

	public String GetName () {
		return new String (NAME);
	}
	
	/**
	 *	Try to solve the problem.
	 */

	public void Solve () {

		Domain d = net.GetVariable (0).GetDomain ();

		try {
			RecursiveSolve (0, d.GetSize ());
		} catch (SolutionFoundException e) {
		}
	}
	
	/*
	 *	Solve the constraint network using the simple BACKTRACKING (BT) method. If a
	 *	solution is found then notify it and return the value according to whether the
	 *	first solution is desired or all solutions. Otherwise, begin checking each
	 *	possible instantiation of the variable. For each domain value, perform the
	 *	following steps. First, if preprocessing eliminated the value, disregard the
	 *	rest of the loop. Otherwise, instantiate the variable, check if the network is
	 *	still consistent, and then call the backtracking routine recursively. After
	 *	checking all possible domain values, return. [CSPLib]
	 */
	
	private boolean RecursiveSolve (int current, int k) {

		//	Local Variables
		int kk = 0;
		Variable v;
		
		/*
		try {
			Thread.sleep (500);	//	TEST
		} catch (InterruptedException e) {
		}
		*/

		NotifyEnterLevel (current);

		if (current >= size) {

			//	A solution has been found
			
			NotifySolution ();

			if (FindMoreSolutions ()) {
				NotifyLeaveLevel (current);
				return false;
			} else
				throw new SolutionFoundException ();
		}

		for (int i = 0; i < k; i++) {
			if (net.GetConstraint (current, current).GetConstraint (i, i) == false) {
				System.err.println ("BT : variable not consistent with itself !");
				continue;
			}

			indexes[current] = i;
			NotifyInstanciation (current, i);

			if (IsConsistent (current)) {
				if (current < (size - 1)) {
					
					v = net.GetVariable (current + 1);
					kk = v.GetDomain ().GetSize ();
				}
				if (RecursiveSolve (current + 1, kk)) {
					NotifyLeaveLevel (current);
					return true;
				}
			}
		}

		NotifyLeaveLevel (current);
		return false;
	}

	/*
	 *	Check if the current instantiation of the variables is consistent
	 *	by looking at the edge between the current variable and all previous
	 *	variables. [CSPLib]
	 */

	private boolean IsConsistent (int current) {
		for (int i = 0; i < current; i++) {
			NotifyConsistencyCheck ();

			if (net.GetConstraint (i, current)
				.GetConstraint (indexes[i], indexes[current]) == false)
				return false;
		}

		return true;
	}
}
