/*
 * Decompiled with CFR 0.152.
 */
package IA_Project.search;

import IA_Project.search.ControlParametersBean;
import IA_Project.search.Graph;
import IA_Project.search.GraphCanvas;
import IA_Project.search.MethodSearching;
import IA_Project.search.Node;
import IA_Project.search.ResultPanel;
import IA_Project.search.Town;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class Work {
    private final Graph graph_ = new Graph();
    private final StringProperty villeDep_ = new SimpleStringProperty();
    private final StringProperty villeArr_ = new SimpleStringProperty();
    private final StringProperty method_ = new SimpleStringProperty();
    private static final int MAX_DEPTH_INIT = 2;
    private static final int MAX_DEPTH_LIMIT = 100;
    private int currentMaxDepth;

    public boolean doSearch(GraphCanvas dessin, ResultPanel result, ControlParametersBean oldBean) {
        this.graph_.initPaths();
        if (oldBean.computeAutomaticHeuristicProperty().get()) {
            this.graph_.putDefaultHeuristics((String)this.villeArr_.get());
        }
        oldBean.showPathProperty().set(false);
        dessin.erasedGraph();
        dessin.drawGraph();
        result.reInitDetails();
        StringBuilder details = new StringBuilder();
        if (((String)this.method_.get()).equals(MethodSearching.A_STAR.toString())) {
            return this.doStarSearch(dessin, result, oldBean, details);
        }
        if (((String)this.method_.get()).equals(MethodSearching.PROFONDEUR_ITERATIVE.toString())) {
            boolean finish = false;
            this.currentMaxDepth = 2;
            while (!finish && this.currentMaxDepth < 100) {
                finish = this.doIDSearch(dessin, result, oldBean, details);
                ++this.currentMaxDepth;
            }
            return finish;
        }
        return this.doSimpleSearch(dessin, result, oldBean, details);
    }

    private boolean doSimpleSearch(GraphCanvas dessin, ResultPanel result, ControlParametersBean oldBean, StringBuilder details) {
        ArrayList<Town> closedList = new ArrayList<Town>();
        ArrayList<Node> openList = new ArrayList<Node>();
        Town villeDep = this.graph_.findTown((String)this.villeDep_.get());
        Town villeArr = this.graph_.findTown((String)this.villeArr_.get());
        Node noeudDep = new Node(villeDep, null);
        noeudDep.setCost(0);
        openList.add(noeudDep);
        int step = 1;
        while (!openList.isEmpty()) {
            Node noeudCour = (Node)openList.remove(0);
            if (closedList.contains(noeudCour.getDescription())) continue;
            if (noeudCour.IsSolution(villeArr)) {
                this.appendLastStepToString(details, noeudCour, step);
                this.graph_.createPath(noeudCour);
                if (!oldBean.stepByStepProperty().get()) {
                    result.setDetails(details.toString());
                    oldBean.showPathProperty().set(true);
                    dessin.erasedGraph();
                    dessin.drawGraph();
                } else {
                    result.setStringToken(new StringTokenizer(details.toString(), "\n"));
                    result.getResultText().appendText(result.getStringToken().nextToken());
                    result.getResultText().appendText("\n");
                    if (result.getStringToken().hasMoreElements()) {
                        result.enableDetailsButton();
                    }
                }
                return true;
            }
            closedList.add(noeudCour.getDescription());
            ArrayList<Node> newNodes = new ArrayList<Node>(noeudCour.successors((String)this.method_.get()));
            this.appendNodes(openList, newNodes, (String)this.method_.get());
            this.appendNewStepToString(details, noeudCour, openList, step);
            ++step;
        }
        return false;
    }

    private boolean doIDSearch(GraphCanvas dessin, ResultPanel result, ControlParametersBean oldBean, StringBuilder details) {
        ArrayList<Node> closedList = new ArrayList<Node>();
        ArrayList<Node> openList = new ArrayList<Node>();
        Town villeDep = this.graph_.findTown((String)this.villeDep_.get());
        Town villeArr = this.graph_.findTown((String)this.villeArr_.get());
        Node noeudDep = new Node(villeDep, null);
        noeudDep.setCost(0);
        noeudDep.setDepth(0);
        openList.add(noeudDep);
        ArrayList<Object> succList = new ArrayList();
        Node noeudCour = noeudDep;
        boolean alreadyListed = false;
        Node oldSuccNode = new Node();
        int step = 1;
        int depth = 0;
        while (!openList.isEmpty()) {
            noeudCour = (Node)openList.remove(0);
            closedList.add(noeudCour);
            if (noeudCour.IsSolution(villeArr)) {
                this.appendLastStepToString(details, noeudCour, step);
                this.graph_.createPath(noeudCour);
                if (!oldBean.stepByStepProperty().get()) {
                    result.setDetails(details.toString());
                    oldBean.showPathProperty().set(true);
                    dessin.erasedGraph();
                    dessin.drawGraph();
                } else {
                    result.setStringToken(new StringTokenizer(details.toString(), "\n"));
                    result.getResultText().appendText(result.getStringToken().nextToken());
                    result.getResultText().appendText("\n");
                    if (result.getStringToken().hasMoreElements()) {
                        result.enableDetailsButton();
                    }
                }
                return true;
            }
            succList = noeudCour.successors((String)this.method_.get());
            LinkedList<Node> validSuccessor = new LinkedList<Node>();
            if (depth < this.currentMaxDepth && !succList.isEmpty()) {
                for (Node node : succList) {
                    int i = 0;
                    while (i < openList.size() && !alreadyListed) {
                        if (node.getDescription().equals(((Node)openList.get(i)).getDescription())) {
                            alreadyListed = true;
                            oldSuccNode = (Node)openList.get(i);
                        }
                        ++i;
                    }
                    if (!alreadyListed) {
                        i = 0;
                        while (i < closedList.size() && !alreadyListed) {
                            if (node.getDescription().equals(((Node)closedList.get(i)).getDescription())) {
                                alreadyListed = true;
                                oldSuccNode = (Node)closedList.get(i);
                            }
                            ++i;
                        }
                    }
                    if (!alreadyListed) {
                        validSuccessor.add(node);
                    } else if (oldSuccNode.getDepth() >= node.getDepth()) {
                        if (closedList.contains(oldSuccNode)) {
                            closedList.remove(oldSuccNode);
                        } else {
                            openList.remove(oldSuccNode);
                        }
                        validSuccessor.add(node);
                    }
                    alreadyListed = false;
                }
                this.appendNodes(openList, validSuccessor, (String)this.method_.get());
                ++depth;
            } else if (!openList.isEmpty()) {
                depth = ((Node)openList.get(0)).getDepth();
            }
            this.appendNewStepToString(details, noeudCour, openList, step);
            ++step;
        }
        return false;
    }

    private boolean doStarSearch(GraphCanvas dessin, ResultPanel result, ControlParametersBean oldBean, StringBuilder details) {
        ArrayList<Node> closedList = new ArrayList<Node>();
        ArrayList<Node> openList = new ArrayList<Node>();
        Town villeDep = this.graph_.findTown((String)this.villeDep_.get());
        Town villeArr = this.graph_.findTown((String)this.villeArr_.get());
        Node noeudDep = new Node(villeDep, null);
        noeudDep.setCost(0);
        openList.add(noeudDep);
        ArrayList<Object> succList = new ArrayList();
        Node noeudCour = noeudDep;
        boolean alreadyListed = false;
        Node oldSuccNode = new Node();
        int step = 1;
        while (!openList.isEmpty() && !noeudCour.IsSolution(villeArr)) {
            noeudCour = (Node)openList.remove(0);
            closedList.add(noeudCour);
            succList = noeudCour.successors((String)this.method_.get());
            for (Node node : succList) {
                int i = 0;
                while (i < openList.size() && !alreadyListed) {
                    if (node.getDescription().equals(((Node)openList.get(i)).getDescription())) {
                        alreadyListed = true;
                        oldSuccNode = (Node)openList.get(i);
                    }
                    ++i;
                }
                if (!alreadyListed) {
                    i = 0;
                    while (i < closedList.size() && !alreadyListed) {
                        if (node.getDescription().equals(((Node)closedList.get(i)).getDescription())) {
                            alreadyListed = true;
                            oldSuccNode = (Node)closedList.get(i);
                        }
                        ++i;
                    }
                }
                if (!alreadyListed) {
                    this.appendNodes(openList, Arrays.asList(node), (String)this.method_.get());
                } else if (oldSuccNode.getCost() > node.getCost()) {
                    oldSuccNode.setAncestor(noeudCour);
                    oldSuccNode.setCost(node.getCost());
                    oldSuccNode.setFinalCost(node.getFinalCost());
                    if (openList.contains(oldSuccNode)) {
                        openList.remove(oldSuccNode);
                    } else {
                        closedList.remove(oldSuccNode);
                    }
                    this.appendNodes(openList, Arrays.asList(oldSuccNode), (String)this.method_.get());
                }
                alreadyListed = false;
            }
            this.appendNewStepToString(details, noeudCour, openList, step);
            ++step;
            if (openList.isEmpty()) continue;
            noeudCour = (Node)openList.get(0);
        }
        if (noeudCour.IsSolution(villeArr)) {
            this.appendLastStepToString(details, noeudCour, step);
            this.graph_.createPath(noeudCour);
            if (!oldBean.stepByStepProperty().get()) {
                result.setDetails(details.toString());
                oldBean.showPathProperty().set(true);
                dessin.erasedGraph();
                dessin.drawGraph();
            } else {
                result.setStringToken(new StringTokenizer(details.toString(), "\n"));
                result.getResultText().appendText(result.getStringToken().nextToken());
                result.getResultText().appendText("\n");
                if (result.getStringToken().hasMoreElements()) {
                    result.enableDetailsButton();
                }
            }
            return true;
        }
        return false;
    }

    private void appendNodes(List<Node> currentList, List<Node> nodesToAdd, String methode) {
        if (MethodSearching.PROFONDEUR_DABORD.toString().equals(methode) || MethodSearching.PROFONDEUR_ITERATIVE.toString().equals(methode)) {
            currentList.addAll(0, nodesToAdd);
        } else if (MethodSearching.LARGEUR_DABORD.toString().equals(methode)) {
            currentList.addAll(currentList.size(), nodesToAdd);
        } else if (MethodSearching.A_STAR.toString().equals(methode)) {
            currentList.addAll(currentList.size(), nodesToAdd);
            this.sortNodes(currentList);
        }
    }

    private void sortNodes(List<Node> nodes) {
        boolean sorted = false;
        int i = nodes.size() - 1;
        while (i > 0 && !sorted) {
            sorted = true;
            int j = 0;
            while (j < i) {
                Node n1 = nodes.get(j);
                Node n2 = nodes.get(j + 1);
                if (n1.getFinalCost() > n2.getFinalCost()) {
                    nodes.set(j, n2);
                    nodes.set(j + 1, n1);
                    sorted = false;
                }
                ++j;
            }
            --i;
        }
    }

    public void appendNewStepToString(StringBuilder strB, Node noeudCour, List<Node> openList, int step) {
        if (!strB.toString().equals("")) {
            strB.append("\n");
        }
        if (step < 10) {
            strB.append(" " + step + " - ");
        } else {
            strB.append(String.valueOf(step) + " - ");
        }
        strB.append("Node : " + noeudCour.getDescription().getName());
        if (((String)this.method_.get()).equals(MethodSearching.PROFONDEUR_ITERATIVE.toString())) {
            strB.append("(" + noeudCour.getDepth() + ")");
        }
        if (!openList.isEmpty()) {
            strB.append(" - List : ");
            for (Node n : openList) {
                strB.append(n.getDescription().getName());
                if (((String)this.method_.get()).equals(MethodSearching.A_STAR.toString())) {
                    strB.append("(" + n.getCost() + "+" + n.getDescription().getHeuristic() + "=" + n.getFinalCost() + ") ");
                }
                strB.append(" ");
            }
        }
    }

    public void appendLastStepToString(StringBuilder strB, Node noeudCour, int step) {
        if (!strB.toString().equals("")) {
            strB.append("\n");
        }
        if (step < 10) {
            strB.append(" " + step + " - ");
        } else {
            strB.append(String.valueOf(step) + " - ");
        }
        strB.append("Node : " + noeudCour.getDescription().getName() + " - Total cost : " + noeudCour.getCost());
    }

    public Graph getGraph() {
        return this.graph_;
    }

    public StringProperty getVilleDep() {
        return this.villeDep_;
    }

    public StringProperty getVilleArr() {
        return this.villeArr_;
    }

    public StringProperty getMethod() {
        return this.method_;
    }
}

