/*
 * Decompiled with CFR 0.152.
 */
package IA_Project.search;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;

public class Town {
    private String name;
    private Optional<Integer> coordX;
    private Optional<Integer> coordY;
    private List<Town> vNeighbor;
    private IntegerProperty heuristic;

    public Town() {
        this.name = new String();
        this.coordX = Optional.empty();
        this.coordY = Optional.empty();
        this.vNeighbor = new ArrayList<Town>();
        this.heuristic = new SimpleIntegerProperty();
    }

    public Town(String nom, int cX, int cY) {
        this.name = nom;
        this.coordX = Optional.of(cX);
        this.coordY = Optional.of(cY);
        this.vNeighbor = new ArrayList<Town>();
        this.heuristic = new SimpleIntegerProperty();
    }

    public String getName() {
        return this.name;
    }

    public int getX() {
        return this.coordX.get();
    }

    public int getY() {
        return this.coordY.get();
    }

    public ArrayList<Town> getNeighbor() {
        return new ArrayList<Town>(this.vNeighbor);
    }

    public IntegerProperty heuristicProperty() {
        return this.heuristic;
    }

    public int getHeuristic() {
        return this.heuristic.get();
    }

    public void setHeuristic(int newValue) {
        this.heuristic.set(newValue);
    }

    public void addRoad(Town ville) {
        this.vNeighbor.add(ville);
    }

    public int straightLineDistance(Town ville) {
        int x1 = this.coordX.get();
        int y1 = this.coordY.get();
        int x2 = ville.coordX.get();
        int y2 = ville.coordY.get();
        double d = Math.pow(Math.abs(x2 - x1), 2.0) + Math.pow(Math.abs(y2 - y1), 2.0);
        d = Math.sqrt(d);
        return Math.round((float)d);
    }

    public void print() {
        System.out.println("Ville : " + this.name);
        System.out.println("X = " + this.coordX.get() + ", Y = " + this.coordY.get());
        System.out.println("Valeur heuristique : " + this.heuristic.get());
        System.out.print("Voisins : ");
        for (Town neighbor : this.vNeighbor) {
            System.out.print(String.valueOf(neighbor.getName()) + " ");
        }
        System.out.println();
    }

    protected Town clone() {
        Town town = new Town();
        town.name = this.name;
        town.coordX = this.coordX;
        town.coordY = this.coordY;
        town.vNeighbor = new ArrayList<Town>(this.vNeighbor);
        town.heuristic = this.heuristic;
        return town;
    }
}

