/*
 * Decompiled with CFR 0.152.
 */
package IA_Project.search;

import IA_Project.search.ControlParametersBean;
import IA_Project.search.GraphCanvas;
import java.util.StringTokenizer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.layout.GridPane;

public class ResultPanel
extends Parent {
    private final TextArea resultText;
    private final Button nextButton;
    private final Button finishButton;
    private BooleanProperty showSteps;
    private StringTokenizer strTok_;

    public ResultPanel(ControlParametersBean cPM, GraphCanvas dessin) {
        Label presentation = new Label("   Details of the search :");
        this.resultText = new TextArea();
        this.resultText.editableProperty().set(false);
        this.resultText.prefRowCountProperty().set(3);
        this.nextButton = new Button("Next step");
        this.nextButton.setOnMouseClicked(value -> this.nextStep(cPM, dessin));
        this.finishButton = new Button("Finish");
        this.finishButton.setOnMouseClicked(value -> this.finalStep(cPM, dessin));
        this.disableDetailsButton();
        this.showSteps = new SimpleBooleanProperty();
        this.showSteps.bind((ObservableValue)cPM.stepByStepProperty());
        GridPane resultGrid = new GridPane();
        resultGrid.addRow(0, new Node[]{presentation});
        resultGrid.addRow(1, new Node[]{this.resultText, this.nextButton, this.finishButton});
        resultGrid.setVgap(5.0);
        resultGrid.setHgap(30.0);
        this.getChildren().add((Object)resultGrid);
        this.setTranslateY(-70.0);
        this.setTranslateX(60.0);
    }

    private void nextStep(ControlParametersBean oldBean, GraphCanvas dessin) {
        this.resultText.appendText(this.strTok_.nextToken());
        this.resultText.appendText("\n");
        if (!this.strTok_.hasMoreTokens()) {
            this.lastStepShawn(oldBean, dessin);
        }
    }

    private void finalStep(ControlParametersBean oldBean, GraphCanvas dessin) {
        while (this.strTok_.hasMoreTokens()) {
            this.resultText.appendText(this.strTok_.nextToken());
            this.resultText.appendText("\n");
        }
        this.lastStepShawn(oldBean, dessin);
    }

    private void lastStepShawn(ControlParametersBean oldBean, GraphCanvas dessin) {
        oldBean.showPathProperty().set(true);
        dessin.erasedGraph();
        dessin.drawGraph();
        this.disableDetailsButton();
    }

    public void setDetails(String str) {
        this.resultText.setText(str);
    }

    public void reInitDetails() {
        this.resultText.setText("");
    }

    public TextArea getResultText() {
        return this.resultText;
    }

    public StringTokenizer getStringToken() {
        return this.strTok_;
    }

    public void setStringToken(StringTokenizer strTok) {
        this.strTok_ = strTok;
    }

    protected void enableDetailsButton() {
        this.nextButton.setDisable(false);
        this.finishButton.setDisable(false);
    }

    protected void disableDetailsButton() {
        this.nextButton.setDisable(true);
        this.finishButton.setDisable(true);
    }
}

