/*
 * Decompiled with CFR 0.152.
 */
package IA_Project.search;

import IA_Project.search.MethodSearching;
import IA_Project.search.Road;
import IA_Project.search.SearchApplication;
import IA_Project.search.Town;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

public class Node {
    private Town description;
    private Optional<Integer> cost;
    private Optional<Integer> finalCost;
    private Optional<Integer> depth;
    private Node ancestor;

    public Node(Town description, Node ancestor) {
        this.description = Objects.requireNonNull(description);
        this.ancestor = ancestor;
        this.depth = Optional.empty();
    }

    public Node() {
        this.description = new Town();
        this.cost = Optional.empty();
        this.finalCost = Optional.empty();
        this.depth = Optional.empty();
        this.ancestor = null;
    }

    public Node getAncestor() {
        return this.ancestor;
    }

    protected void setAncestor(Node ancetre) {
        this.ancestor = ancetre;
    }

    public Town getDescription() {
        return this.description;
    }

    public int getFinalCost() {
        return this.finalCost.get();
    }

    protected void setFinalCost(int coutFinal) {
        this.finalCost = Optional.of(coutFinal);
    }

    public int getDepth() {
        return this.depth.get();
    }

    protected void setDepth(int currentDepth) {
        this.depth = Optional.of(currentDepth);
    }

    public int getCost() {
        return this.cost.get();
    }

    protected void setCost(int cout) {
        this.cost = Optional.of(cout);
    }

    public void print() {
        System.out.println("Noeud de recherche : " + this.description.getName());
        System.out.println("Co\u00fbt = " + this.cost + " Cout final estime = " + this.finalCost);
        System.out.println("Parent : " + this.ancestor.description.getName());
    }

    public ArrayList<Node> successors(String methode) {
        ArrayList<Node> successeurs = new ArrayList<Node>();
        for (Town voisin : this.description.getNeighbor()) {
            Node newNode = new Node(voisin, this);
            int oldCost = 0;
            if (newNode.ancestor != null) {
                oldCost = this.cost.get();
            }
            Road rte = SearchApplication.getWork().getGraph().findRoad(newNode.ancestor.description, newNode.description);
            newNode.cost = Optional.of(oldCost + rte.getCost());
            if (methode.equals(MethodSearching.A_STAR.toString())) {
                newNode.finalCost = Optional.of(newNode.cost.get() + voisin.getHeuristic());
            }
            if (methode.equals(MethodSearching.PROFONDEUR_ITERATIVE.toString())) {
                newNode.setDepth(this.depth.get() + 1);
            }
            successeurs.add(newNode);
        }
        return successeurs;
    }

    public boolean IsSolution(Town ville) {
        return this.description.getName().equals(ville.getName());
    }
}

