/*
 * Decompiled with CFR 0.152.
 */
package IA_Project.search;

import IA_Project.search.ControlParametersBean;
import IA_Project.search.Graph;
import IA_Project.search.Town;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Application;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.Property;
import javafx.event.Event;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.StringConverter;
import javafx.util.converter.IntegerStringConverter;

public class HeuristicWindow
extends Application {
    private static final int PREF_COLUMN_SIZE_MEDIUM = 4;
    private static final double HORIZONTAL_GAP_BETWEEN_GRID_ELEMENT = 10.0;
    private static final double VERTICAL_GAP_BETWEEN_GRID_ELEMENT = 3.0;
    private static final int[] GRIDPANE_INSETS = new int[]{15, 5, 5, 5};
    private static final int BIG_CONTROL_BUTTON_WIDTH = 130;
    private static final int SMALL_CONTROL_BUTTON_WIDTH = 80;
    private final ControlParametersBean oldBean2_;
    private final ControlParametersBean newBean2_;
    private final Graph graph_;

    public HeuristicWindow(ControlParametersBean oldbean, ControlParametersBean newbean, Graph graph) {
        this.oldBean2_ = oldbean;
        this.newBean2_ = newbean;
        this.graph_ = graph;
    }

    public void start(Stage primaryStage) {
        GridPane nodesHeuristic = new GridPane();
        List<Town> towns = this.graph_.getTowns();
        IntegerStringConverter ISConverter = new IntegerStringConverter();
        ArrayList<Label> townsLabel = new ArrayList<Label>();
        ArrayList<TextField> townsText = new ArrayList<TextField>();
        int i = 0;
        while (i < towns.size()) {
            townsLabel.add(i, new Label(towns.get(i).getName()));
            TextField tmpField = new TextField();
            TextFormatter formatter = new TextFormatter((StringConverter)ISConverter);
            tmpField.setTextFormatter(formatter);
            tmpField.setAlignment(Pos.CENTER_RIGHT);
            tmpField.setPrefColumnCount(4);
            IntegerProperty objectAsInteger = IntegerProperty.integerProperty((Property)formatter.valueProperty());
            objectAsInteger.bindBidirectional((Property)this.newBean2_.heuristicOfNodesProperty().get(towns.get(i).getName()));
            townsText.add(i, tmpField);
            ++i;
        }
        nodesHeuristic.setAlignment(Pos.CENTER);
        nodesHeuristic.setHgap(10.0);
        nodesHeuristic.setVgap(3.0);
        nodesHeuristic.setPadding(new Insets((double)GRIDPANE_INSETS[0], (double)GRIDPANE_INSETS[1], (double)GRIDPANE_INSETS[2], (double)GRIDPANE_INSETS[3]));
        i = 0;
        while ((double)i < Math.ceil(towns.size() / 2)) {
            nodesHeuristic.addColumn(0, new Node[]{(Node)townsLabel.get(i)});
            nodesHeuristic.addColumn(1, new Node[]{(Node)townsText.get(i)});
            ++i;
        }
        i = (int)Math.ceil(towns.size() / 2);
        while (i < towns.size()) {
            nodesHeuristic.addColumn(3, new Node[]{(Node)townsLabel.get(i)});
            nodesHeuristic.addColumn(4, new Node[]{(Node)townsText.get(i)});
            ++i;
        }
        for (Node n : nodesHeuristic.getChildren()) {
            GridPane.setHalignment((Node)n, (HPos)HPos.CENTER);
        }
        Button defaultButton = new Button("Default values");
        defaultButton.setPrefWidth(130.0);
        defaultButton.setTranslateX(70.0);
        defaultButton.setOnAction(value -> this.putDistanceBasedCosts());
        Button cancelButton = new Button("Cancel");
        cancelButton.setPrefWidth(80.0);
        cancelButton.setOnAction(value -> this.newBean2_.synchronize(this.oldBean2_));
        cancelButton.setOnAction(value -> {
            this.newBean2_.synchronize(this.oldBean2_);
            primaryStage.fireEvent((Event)new WindowEvent((Window)primaryStage, WindowEvent.WINDOW_CLOSE_REQUEST));
        });
        Button okButton = new Button("Enter");
        okButton.setPrefWidth(80.0);
        okButton.setOnAction(value -> this.oldBean2_.synchronize(this.newBean2_));
        okButton.setOnAction(value -> {
            this.oldBean2_.synchronize(this.newBean2_);
            primaryStage.fireEvent((Event)new WindowEvent((Window)primaryStage, WindowEvent.WINDOW_CLOSE_REQUEST));
        });
        GridPane heuristicControl = new GridPane();
        heuristicControl.addRow(0, new Node[]{defaultButton});
        heuristicControl.addRow(1, new Node[]{cancelButton, okButton});
        heuristicControl.setHgap(60.0);
        heuristicControl.setVgap(30.0);
        heuristicControl.setAlignment(Pos.CENTER);
        heuristicControl.setPadding(new Insets((double)GRIDPANE_INSETS[0], (double)GRIDPANE_INSETS[1], (double)(8 * GRIDPANE_INSETS[2]), (double)GRIDPANE_INSETS[3]));
        BorderPane root = new BorderPane((Node)nodesHeuristic, null, null, (Node)heuristicControl, null);
        Scene scene = new Scene((Parent)root, 400.0, 420.0);
        primaryStage.setTitle("Heuristics");
        primaryStage.setScene(scene);
        primaryStage.setResizable(false);
        primaryStage.show();
    }

    private void putDistanceBasedCosts() {
        for (Town ville : this.graph_.getTowns()) {
            this.newBean2_.heuristicOfNodesProperty().get(ville.getName()).set(ville.straightLineDistance(this.graph_.findTown((String)this.newBean2_.villeArriveeProperty().get())));
        }
    }
}

