/*
 * Decompiled with CFR 0.152.
 */
package IA_Project.search;

import IA_Project.search.ControlParametersBean;
import IA_Project.search.Graph;
import IA_Project.search.Road;
import IA_Project.search.Town;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;

public class GraphCanvas
extends Canvas {
    private static final int WIDTH_BORDER = 3;
    private static final Color COLOR_BORDER = Color.BLACK;
    private static final Color COLOR_EDGE = Color.DARKGRAY;
    private static final Color COLOR_PATH = Color.RED;
    private static final Color COLOR_TOWN = Color.LIGHTGRAY;
    private static final Color COLOR_BACKGROUND = Color.WHITE;
    private static final int OVAL_HEIGHT = 30;
    private static final int OVAL_WIDTH = 40;
    private static final Color COLOR_FONT_NAME = Color.BLACK;
    private static final Font FONT_NAME = new Font("Courrier", 14.0);
    private static final int DX = -5;
    private static final int DY = 5;
    private static final Font FONT_VALUE = new Font("Courrier", 12.0);
    private static final Color COLOR_FONT_HEURISTIC = Color.BLUE;
    private static final Color COLOR_FONT_ROAD = Color.CORNFLOWERBLUE;
    private final Graph graph_;
    private final GraphicsContext graphics_;
    private BooleanProperty showPath_;
    private BooleanProperty showGraphValues_;

    public GraphCanvas(int height, int width, Graph graph, ControlParametersBean cPM) {
        super((double)height, (double)width);
        this.graph_ = graph;
        this.graphics_ = this.getGraphicsContext2D();
        this.showPath_ = new SimpleBooleanProperty();
        this.showGraphValues_ = new SimpleBooleanProperty();
        this.showPath_.bind((ObservableValue)cPM.showPathProperty());
        this.showGraphValues_.bind((ObservableValue)cPM.showValuesProperty());
        this.drawGraph();
    }

    protected void drawGraph() {
        this.graphics_.setFill((Paint)COLOR_BACKGROUND);
        this.graphics_.fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
        this.graphics_.setStroke((Paint)COLOR_BORDER);
        this.graphics_.setLineWidth(3.0);
        this.graphics_.strokeRoundRect(0.0, 0.0, this.getWidth(), this.getHeight(), 0.0, 0.0);
        this.drawRoads();
        this.drawSummits();
    }

    protected void erasedGraph() {
        this.graphics_.clearRect(0.0, 0.0, this.getWidth(), this.getHeight());
    }

    private void drawRoads() {
        List<Road> routes = this.graph_.getRoads();
        int i = 0;
        while (i < routes.size()) {
            Road route = routes.get(i);
            Town origine = route.getOrigine();
            Town extremite = route.getExtremite();
            if (this.showPath_.getValue().booleanValue() && this.graph_.getPaths().get(i).booleanValue()) {
                this.graphics_.setStroke((Paint)COLOR_PATH);
            } else {
                this.graphics_.setStroke((Paint)COLOR_EDGE);
            }
            this.graphics_.strokeLine((double)origine.getX(), (double)origine.getY(), (double)extremite.getX(), (double)extremite.getY());
            if (this.showGraphValues_.getValue().booleanValue()) {
                int middleX = Math.min(origine.getX(), extremite.getX()) + Math.abs(origine.getX() - extremite.getX()) / 2;
                int middleY = Math.min(origine.getY(), extremite.getY()) + Math.abs(origine.getY() - extremite.getY()) / 2;
                this.graphics_.setFill((Paint)COLOR_FONT_ROAD);
                this.graphics_.setFont(FONT_VALUE);
                String roadCost = new Integer(route.getCost()).toString();
                this.graphics_.fillText(roadCost, (double)middleX, (double)middleY);
            }
            ++i;
        }
    }

    private void drawSummits() {
        List<Town> villes = this.graph_.getTowns();
        int i = 0;
        while (i < villes.size()) {
            Town town = villes.get(i);
            this.graphics_.setFill((Paint)COLOR_TOWN);
            this.graphics_.setStroke((Paint)COLOR_BORDER);
            this.graphics_.fillOval((double)(town.getX() - 20), (double)(town.getY() - 15), 40.0, 30.0);
            this.graphics_.strokeOval((double)(town.getX() - 20), (double)(town.getY() - 15), 40.0, 30.0);
            this.graphics_.setFill((Paint)COLOR_FONT_NAME);
            this.graphics_.setFont(FONT_NAME);
            this.graphics_.fillText(town.getName(), (double)(town.getX() + -5), (double)(town.getY() + 5));
            if (this.showGraphValues_.getValue().booleanValue()) {
                this.graphics_.setFill((Paint)COLOR_FONT_HEURISTIC);
                this.graphics_.setFont(FONT_VALUE);
                StringBuilder sbh = new StringBuilder();
                sbh.append("(").append(new Integer(town.getHeuristic()).toString()).append(")");
                this.graphics_.fillText(sbh.toString(), (double)(town.getX() + 10), (double)(town.getY() - 15));
            }
            ++i;
        }
    }
}

