/*
 * Decompiled with CFR 0.152.
 */
package IA_Project.search;

import IA_Project.search.Node;
import IA_Project.search.Road;
import IA_Project.search.Town;
import java.util.ArrayList;
import java.util.List;

public class Graph {
    private List<Town> towns;
    private List<Road> roads;
    private List<Boolean> path;

    public Graph() {
        this.initDefaultTowns();
        this.initDefaultRoads();
        this.initPaths();
        this.createNeighborsOfTowns();
        this.putDefaultCosts();
        this.putDefaultHeuristics(this.towns.get(this.towns.size() - 1).getName());
    }

    private void initDefaultTowns() {
        this.towns = new ArrayList<Town>();
        this.towns.add(new Town("A", 48, 48));
        this.towns.add(new Town("B", 120, 120));
        this.towns.add(new Town("C", 48, 192));
        this.towns.add(new Town("D", 120, 240));
        this.towns.add(new Town("E", 204, 36));
        this.towns.add(new Town("F", 264, 120));
        this.towns.add(new Town("G", 480, 48));
        this.towns.add(new Town("H", 444, 360));
        this.towns.add(new Town("I", 204, 192));
        this.towns.add(new Town("J", 312, 264));
        this.towns.add(new Town("K", 192, 312));
        this.towns.add(new Town("L", 384, 48));
        this.towns.add(new Town("M", 408, 144));
        this.towns.add(new Town("N", 396, 276));
        this.towns.add(new Town("O", 360, 360));
        this.towns.add(new Town("P", 108, 360));
    }

    private void initDefaultRoads() {
        this.roads = new ArrayList<Road>();
        this.roads.add(new Road(this.findTown("A"), this.findTown("B")));
        this.roads.add(new Road(this.findTown("A"), this.findTown("E")));
        this.roads.add(new Road(this.findTown("B"), this.findTown("C")));
        this.roads.add(new Road(this.findTown("B"), this.findTown("E")));
        this.roads.add(new Road(this.findTown("B"), this.findTown("D")));
        this.roads.add(new Road(this.findTown("B"), this.findTown("I")));
        this.roads.add(new Road(this.findTown("B"), this.findTown("F")));
        this.roads.add(new Road(this.findTown("C"), this.findTown("D")));
        this.roads.add(new Road(this.findTown("C"), this.findTown("P")));
        this.roads.add(new Road(this.findTown("D"), this.findTown("I")));
        this.roads.add(new Road(this.findTown("D"), this.findTown("K")));
        this.roads.add(new Road(this.findTown("E"), this.findTown("F")));
        this.roads.add(new Road(this.findTown("E"), this.findTown("L")));
        this.roads.add(new Road(this.findTown("F"), this.findTown("I")));
        this.roads.add(new Road(this.findTown("F"), this.findTown("L")));
        this.roads.add(new Road(this.findTown("F"), this.findTown("M")));
        this.roads.add(new Road(this.findTown("G"), this.findTown("H")));
        this.roads.add(new Road(this.findTown("G"), this.findTown("L")));
        this.roads.add(new Road(this.findTown("G"), this.findTown("M")));
        this.roads.add(new Road(this.findTown("I"), this.findTown("J")));
        this.roads.add(new Road(this.findTown("J"), this.findTown("K")));
        this.roads.add(new Road(this.findTown("J"), this.findTown("N")));
        this.roads.add(new Road(this.findTown("K"), this.findTown("O")));
        this.roads.add(new Road(this.findTown("K"), this.findTown("P")));
        this.roads.add(new Road(this.findTown("M"), this.findTown("N")));
        this.roads.add(new Road(this.findTown("N"), this.findTown("O")));
        this.roads.add(new Road(this.findTown("P"), this.findTown("O")));
    }

    protected void initPaths() {
        this.path = new ArrayList<Boolean>(this.roads.size());
        int i = 0;
        while (i < this.roads.size()) {
            this.path.add(i, false);
            ++i;
        }
    }

    private void createNeighborsOfTowns() {
        for (Road route : this.roads) {
            Town ville1 = this.findTown(route.getOrigine().getName());
            Town ville2 = this.findTown(route.getExtremite().getName());
            if (ville1 != null && ville2 != null) {
                ville1.addRoad(ville2);
                ville2.addRoad(ville1);
                continue;
            }
            System.out.println("\nAvertissement : ");
            System.out.println("La route " + route.getOrigine().getName() + "-" + route.getExtremite().getName() + " ne peut pas etre definie.");
        }
    }

    private void putDefaultCosts() {
        for (Road route : this.roads) {
            route.setCost(route.getOrigine().straightLineDistance(route.getExtremite()));
        }
    }

    protected void putDefaultHeuristics(String strArr) {
        Town villeArr = this.findTown(strArr);
        for (Town ville : this.towns) {
            ville.setHeuristic(ville.straightLineDistance(villeArr));
        }
    }

    public Town findTown(String nom) {
        for (Town ville : this.towns) {
            if (!ville.getName().equals(nom)) continue;
            return ville;
        }
        return null;
    }

    public Road findRoad(Town ville1, Town ville2) {
        for (Road route : this.roads) {
            String name1 = route.getOrigine().getName();
            String name2 = route.getExtremite().getName();
            if ((!name1.equals(ville1.getName()) || !name2.equals(ville2.getName())) && (!name1.equals(ville2.getName()) || !name2.equals(ville1.getName()))) continue;
            return route;
        }
        return null;
    }

    public int indexOfRoad(Town ville1, Town ville2) {
        Road route = this.findRoad(ville1, ville2);
        return this.roads.indexOf(route);
    }

    public void createPath(Node noeud) {
        Node noeudCour = noeud;
        while (noeudCour.getAncestor() != null) {
            Town ville1 = noeudCour.getAncestor().getDescription();
            Town ville2 = noeudCour.getDescription();
            this.path.set(this.indexOfRoad(ville1, ville2), true);
            noeudCour = noeudCour.getAncestor();
        }
    }

    public List<Road> getRoads() {
        return this.roads;
    }

    public List<Town> getTowns() {
        return this.towns;
    }

    public List<Boolean> getPaths() {
        return this.path;
    }
}

