/*
 * Decompiled with CFR 0.152.
 */
package IA_Project.search;

import IA_Project.search.ControlParametersBean;
import IA_Project.search.Graph;
import IA_Project.search.Road;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Application;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.Property;
import javafx.event.Event;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.StringConverter;
import javafx.util.converter.IntegerStringConverter;

public class CostWindow
extends Application {
    private static final int PREF_COLUMN_SIZE_MEDIUM = 4;
    private static final double HORIZONTAL_GAP_BETWEEN_GRID_ELEMENT = 10.0;
    private static final double VERTICAL_GAP_BETWEEN_GRID_ELEMENT = 3.0;
    private static final int[] GRIDPANE_INSETS = new int[]{15, 5, 5, 5};
    private static final int CONTROL_BUTTON_WIDTH = 75;
    private final ControlParametersBean oldBean2_;
    private final ControlParametersBean newBean2_;
    private final Graph graph_;

    public CostWindow(ControlParametersBean oldbean, ControlParametersBean newbean, Graph graph) {
        this.oldBean2_ = oldbean;
        this.newBean2_ = newbean;
        this.graph_ = graph;
    }

    public void start(Stage primaryStage) {
        GridPane roadsCost = new GridPane();
        List<Road> roads = this.graph_.getRoads();
        IntegerStringConverter ISConverter = new IntegerStringConverter();
        ArrayList<Label> roadsLabel = new ArrayList<Label>();
        ArrayList<TextField> roadsText = new ArrayList<TextField>();
        int i = 0;
        while (i < roads.size()) {
            roadsLabel.add(i, new Label(roads.get(i).toString()));
            TextField tmpField = new TextField();
            TextFormatter formatter = new TextFormatter((StringConverter)ISConverter);
            tmpField.setTextFormatter(formatter);
            tmpField.setAlignment(Pos.CENTER_RIGHT);
            tmpField.setPrefColumnCount(4);
            IntegerProperty objectAsInteger = IntegerProperty.integerProperty((Property)formatter.valueProperty());
            objectAsInteger.bindBidirectional((Property)this.newBean2_.costOfRoadsProperty().get(roads.get(i).toString()));
            roadsText.add(i, tmpField);
            ++i;
        }
        roadsCost.setAlignment(Pos.CENTER);
        roadsCost.setHgap(10.0);
        roadsCost.setVgap(3.0);
        roadsCost.setPadding(new Insets((double)GRIDPANE_INSETS[0], (double)GRIDPANE_INSETS[1], (double)GRIDPANE_INSETS[2], (double)GRIDPANE_INSETS[3]));
        i = 0;
        while ((double)i < Math.ceil(roads.size() / 2)) {
            roadsCost.addColumn(0, new Node[]{(Node)roadsLabel.get(i)});
            roadsCost.addColumn(1, new Node[]{(Node)roadsText.get(i)});
            ++i;
        }
        i = (int)Math.ceil(roads.size() / 2);
        while (i < roads.size()) {
            roadsCost.addColumn(3, new Node[]{(Node)roadsLabel.get(i)});
            roadsCost.addColumn(4, new Node[]{(Node)roadsText.get(i)});
            ++i;
        }
        for (Node n : roadsCost.getChildren()) {
            GridPane.setHalignment((Node)n, (HPos)HPos.CENTER);
        }
        Button zeroButton = new Button("All to 0");
        zeroButton.setPrefWidth(75.0);
        zeroButton.setOnAction(e -> this.putAllNullCosts());
        Button unButton = new Button("All to 1");
        unButton.setPrefWidth(75.0);
        unButton.setOnAction(e -> this.putAllOneCosts());
        Button distanceButton = new Button("Distance");
        distanceButton.setPrefWidth(75.0);
        distanceButton.setOnAction(e -> this.putDistanceBasedCosts());
        Button cancelButton = new Button("Cancel");
        cancelButton.setPrefWidth(75.0);
        cancelButton.setTranslateX(60.0);
        cancelButton.setOnAction(value -> {
            this.newBean2_.synchronize(this.oldBean2_);
            primaryStage.fireEvent((Event)new WindowEvent((Window)primaryStage, WindowEvent.WINDOW_CLOSE_REQUEST));
        });
        Button okButton = new Button("Enter");
        okButton.setPrefWidth(75.0);
        okButton.setTranslateX(60.0);
        okButton.setOnAction(value -> {
            this.oldBean2_.synchronize(this.newBean2_);
            primaryStage.fireEvent((Event)new WindowEvent((Window)primaryStage, WindowEvent.WINDOW_CLOSE_REQUEST));
        });
        GridPane costControl = new GridPane();
        costControl.addRow(0, new Node[]{zeroButton, unButton, distanceButton});
        costControl.addRow(1, new Node[]{cancelButton, okButton});
        costControl.setHgap(50.0);
        costControl.setVgap(30.0);
        costControl.setPadding(new Insets((double)GRIDPANE_INSETS[0], (double)GRIDPANE_INSETS[1], (double)(8 * GRIDPANE_INSETS[2]), (double)GRIDPANE_INSETS[3]));
        costControl.setAlignment(Pos.CENTER);
        GridPane.setHalignment((Node)costControl, (HPos)HPos.CENTER);
        for (Node n : costControl.getChildren()) {
            GridPane.setHalignment((Node)n, (HPos)HPos.CENTER);
        }
        BorderPane root = new BorderPane((Node)roadsCost, null, null, (Node)costControl, null);
        Scene scene = new Scene((Parent)root, 450.0, 600.0);
        primaryStage.setTitle("Costs");
        primaryStage.setScene(scene);
        primaryStage.setResizable(false);
        primaryStage.show();
    }

    private void putAllNullCosts() {
        for (IntegerProperty cost : this.newBean2_.costOfRoadsProperty().values()) {
            cost.set(0);
        }
    }

    private void putAllOneCosts() {
        for (IntegerProperty cost : this.newBean2_.costOfRoadsProperty().values()) {
            cost.set(1);
        }
    }

    private void putDistanceBasedCosts() {
        for (Road route : this.graph_.getRoads()) {
            this.newBean2_.costOfRoadsProperty().get(route.toString()).set(route.getOrigine().straightLineDistance(route.getExtremite()));
        }
    }
}

