/*
 * Decompiled with CFR 0.152.
 */
package IA_Project.search;

import IA_Project.search.ControlParametersBean;
import IA_Project.search.CostWindow;
import IA_Project.search.Graph;
import IA_Project.search.HeuristicWindow;
import IA_Project.search.MethodSearching;
import IA_Project.search.Road;
import IA_Project.search.SearchApplication;
import IA_Project.search.Town;
import IA_Project.search.Work;
import java.util.List;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;

public class ControlPanel
extends Parent {
    private final ControlParametersBean oldBean_;
    private final ControlParametersBean newBean_;

    public ControlPanel(Work work, SearchApplication app) {
        Graph graph = SearchApplication.getWork().getGraph();
        this.oldBean_ = new ControlParametersBean();
        this.newBean_ = new ControlParametersBean();
        List<Road> roads = work.getGraph().getRoads();
        int i = 0;
        while (i < roads.size()) {
            this.newBean_.costOfRoadsProperty().put(roads.get(i).toString(), (IntegerProperty)new SimpleIntegerProperty(roads.get(i).getCost()));
            this.oldBean_.costOfRoadsProperty().put(roads.get(i).toString(), (IntegerProperty)new SimpleIntegerProperty(roads.get(i).getCost()));
            this.oldBean_.costOfRoadsProperty().get(roads.get(i).toString()).bindBidirectional((Property)roads.get(i).costProperty());
            ++i;
        }
        List<Town> towns = work.getGraph().getTowns();
        int i2 = 0;
        while (i2 < towns.size()) {
            this.newBean_.heuristicOfNodesProperty().put(towns.get(i2).getName(), (IntegerProperty)new SimpleIntegerProperty(towns.get(i2).getHeuristic()));
            this.oldBean_.heuristicOfNodesProperty().put(towns.get(i2).getName(), (IntegerProperty)new SimpleIntegerProperty(towns.get(i2).getHeuristic()));
            this.oldBean_.heuristicOfNodesProperty().get(towns.get(i2).getName()).bindBidirectional((Property)towns.get(i2).heuristicProperty());
            ++i2;
        }
        Label begin = new Label("Begin :");
        ChoiceBox beginButton = new ChoiceBox();
        beginButton.setTranslateX(-60.0);
        beginButton.valueProperty().bindBidirectional((Property)this.newBean_.villeDepartProperty());
        Label end = new Label("End :");
        ChoiceBox endButton = new ChoiceBox();
        endButton.setTranslateX(-60.0);
        endButton.valueProperty().bindBidirectional((Property)this.newBean_.villeArriveeProperty());
        int i3 = 0;
        while (i3 < graph.getTowns().size()) {
            beginButton.getItems().add((Object)graph.getTowns().get(i3).getName());
            endButton.getItems().add((Object)graph.getTowns().get(i3).getName());
            ++i3;
        }
        beginButton.getSelectionModel().selectFirst();
        endButton.getSelectionModel().selectLast();
        Label method = new Label("Method :");
        ChoiceBox methodButton = new ChoiceBox();
        methodButton.setTranslateX(-60.0);
        methodButton.getItems().add(0, (Object)MethodSearching.A_STAR.toString());
        methodButton.getItems().add(1, (Object)MethodSearching.LARGEUR_DABORD.toString());
        methodButton.getItems().add(2, (Object)MethodSearching.PROFONDEUR_DABORD.toString());
        methodButton.getItems().add(3, (Object)MethodSearching.PROFONDEUR_ITERATIVE.toString());
        methodButton.getSelectionModel().selectFirst();
        methodButton.valueProperty().bindBidirectional((Property)this.newBean_.methodProperty());
        this.oldBean_.villeDepartProperty().bindBidirectional((Property)work.getVilleDep());
        this.oldBean_.villeArriveeProperty().bindBidirectional((Property)work.getVilleArr());
        this.oldBean_.methodProperty().bindBidirectional((Property)work.getMethod());
        Button costButton = new Button("Costs");
        costButton.setTranslateX(20.0);
        costButton.setOnAction(value -> this.launchCostWindow(app.getStage(), graph));
        Button heuristicButton = new Button("Heuristics");
        heuristicButton.setTranslateX(-20.0);
        heuristicButton.setOnAction(value -> this.launchHeuristicWindow(app.getStage(), graph));
        CheckBox stepChoice = new CheckBox("Step by step execution");
        stepChoice.selectedProperty().bindBidirectional((Property)this.newBean_.stepByStepProperty());
        CheckBox valueChoice = new CheckBox("Show values on graph");
        valueChoice.selectedProperty().bindBidirectional((Property)this.newBean_.showValuesProperty());
        CheckBox automaticHeuristicChoice = new CheckBox("Automatic heuristics computation");
        automaticHeuristicChoice.selectedProperty().bindBidirectional((Property)this.newBean_.computeAutomaticHeuristicProperty());
        Button startButton = new Button("Search");
        startButton.setTranslateX(80.0);
        startButton.setOnMouseClicked(value -> this.searchAction(work, app));
        this.oldBean_.synchronize(this.newBean_);
        GridPane controlGrid = new GridPane();
        controlGrid.addRow(0, new Node[]{begin, beginButton});
        controlGrid.addRow(1, new Node[]{end, endButton});
        controlGrid.addRow(2, new Node[]{method, methodButton});
        controlGrid.addRow(3, new Node[]{costButton, heuristicButton});
        controlGrid.addRow(4, new Node[]{stepChoice});
        controlGrid.addRow(5, new Node[]{valueChoice});
        controlGrid.addRow(6, new Node[]{automaticHeuristicChoice});
        controlGrid.add((Node)startButton, 0, 9, 2, 1);
        controlGrid.setVgap(15.0);
        this.getChildren().add((Object)controlGrid);
        this.setTranslateY(180.0);
        this.setTranslateX(-40.0);
    }

    private void launchCostWindow(Stage parentStage, Graph graph) {
        parentStage.hide();
        Stage costStage = new Stage();
        costStage.setOnCloseRequest(value -> parentStage.show());
        CostWindow costWindow = new CostWindow(this.oldBean_, this.newBean_, graph);
        costWindow.start(costStage);
    }

    private void launchHeuristicWindow(Stage parentStage, Graph graph) {
        parentStage.hide();
        Stage heuristicStage = new Stage();
        heuristicStage.setOnCloseRequest(value -> parentStage.show());
        HeuristicWindow heuristicWindow = new HeuristicWindow(this.oldBean_, this.newBean_, graph);
        heuristicWindow.start(heuristicStage);
    }

    private void searchAction(Work work, SearchApplication app) {
        this.oldBean_.synchronize(this.newBean_);
        work.doSearch(app.getGraphCanvas(), app.getResultPanel(), this.oldBean_);
    }

    public ControlParametersBean getOldBean() {
        return this.oldBean_;
    }
}

