/*
 * Decompiled with CFR 0.152.
 */
package IA_Project.satSolver.solvers;

import IA_Project.satSolver.Environment;
import IA_Project.satSolver.Solution;
import IA_Project.satSolver.Variable;
import java.util.ArrayList;
import java.util.List;

public abstract class Solver {
    private final Environment env_;
    private final List<List<String>> stepByStepAllocation_;
    private final List<List<List<String>>> stepByStepLabels_;
    private int entersCount_;
    private int backtracksCount_;
    private int instantiationsCount_;
    private int checksCount_;

    protected Solver(Environment env) {
        this.env_ = env;
        this.stepByStepAllocation_ = new ArrayList<List<String>>();
        this.stepByStepLabels_ = new ArrayList<List<List<String>>>();
        this.entersCount_ = 0;
        this.backtracksCount_ = 0;
        this.instantiationsCount_ = 0;
        this.checksCount_ = 0;
    }

    public abstract Solution solve();

    protected boolean isConsistent(Variable var, String res, Variable previousVar, String previousRes) {
        this.addCheck();
        return this.env_.getNetwork().getConstraint(previousVar, var).getResourceConstraint(previousRes, res);
    }

    protected Environment getEnv() {
        return this.env_;
    }

    public List<List<String>> getStepByStepAllocation() {
        return this.stepByStepAllocation_;
    }

    protected void addStepAllocation(List<String> nextStep) {
        this.stepByStepAllocation_.add(nextStep);
    }

    protected void clearStepByStepAllocation() {
        this.stepByStepLabels_.clear();
    }

    public abstract boolean hasLabel();

    public List<List<List<String>>> getStepByStepLabels() {
        if (this.hasLabel()) {
            return this.stepByStepLabels_;
        }
        throw new UnsupportedOperationException();
    }

    protected void addStepLabels(List<List<String>> nextStep) {
        this.stepByStepLabels_.add(nextStep);
    }

    protected void clearStepByStepLabels() {
        this.stepByStepLabels_.clear();
    }

    public int getEntersCount() {
        return this.entersCount_;
    }

    protected void addEnter() {
        ++this.entersCount_;
    }

    public int getInstantiationsCount() {
        return this.instantiationsCount_;
    }

    protected void addInstantiation() {
        ++this.instantiationsCount_;
    }

    public int getBacktracksCount() {
        return this.backtracksCount_;
    }

    protected void addBacktrack() {
        ++this.backtracksCount_;
    }

    public int getChecksCount() {
        return this.checksCount_;
    }

    protected void addCheck() {
        ++this.checksCount_;
    }
}

