/*
 * Decompiled with CFR 0.152.
 */
package IA_Project.satSolver.solvers;

import IA_Project.satSolver.Environment;
import IA_Project.satSolver.Solution;
import IA_Project.satSolver.Variable;
import IA_Project.satSolver.solvers.Solver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class LookAheadSolver
extends Solver {
    public LookAheadSolver(Environment env) {
        super(env);
    }

    @Override
    public Solution solve() {
        List<Variable> variables = this.getEnv().getVariables();
        this.clearStepByStepAllocation();
        this.clearStepByStepLabels();
        ArrayList<Set<String>> labels = new ArrayList<Set<String>>();
        int i = 0;
        while (i < variables.size()) {
            labels.add(i, new TreeSet<String>(variables.get(i).getDomain().getResources()));
            ++i;
        }
        this.addStepAllocation(new ArrayList<String>());
        this.addStepLabels(labels.stream().map(s -> new ArrayList(s)).collect(Collectors.toList()));
        List<String> partialSolution = this.LA_DFS(new ArrayList<String>(), labels);
        HashMap<Variable, String> schedule = new HashMap<Variable, String>();
        if (partialSolution.size() == variables.size()) {
            int i2 = 0;
            while (i2 < variables.size()) {
                schedule.put(variables.get(i2), partialSolution.get(i2));
                ++i2;
            }
        }
        return new Solution(schedule);
    }

    private List<String> LA_DFS(List<String> currentSolution, List<Set<String>> labels) {
        List<Variable> variables = this.getEnv().getVariables();
        int k = currentSolution.size();
        if (k >= variables.size()) {
            return currentSolution;
        }
        this.addEnter();
        ArrayList<TreeSet<String>> savedLabels = new ArrayList<TreeSet<String>>();
        for (Set<String> label : labels) {
            savedLabels.add(new TreeSet<String>(label));
        }
        TreeSet labelk = new TreeSet(labels.get(k));
        for (String res : labelk) {
            currentSolution.add(res);
            this.addInstantiation();
            labels.get(k).remove(res);
            ((Set)savedLabels.get(k)).remove(res);
            boolean checkForward = this.lookForward(k, labels, res, IntStream.rangeClosed(0, k).boxed().collect(Collectors.toSet()));
            this.addStepAllocation(new ArrayList<String>(currentSolution));
            List<List<String>> l = labels.stream().map(s -> new ArrayList(s)).collect(Collectors.toList());
            this.addStepLabels(l);
            if (checkForward) {
                this.LA_DFS(currentSolution, labels);
            }
            if (currentSolution.size() >= variables.size()) {
                return currentSolution;
            }
            currentSolution.remove(k);
            labels.clear();
            for (Set set : savedLabels) {
                labels.add(new TreeSet(set));
            }
        }
        this.addBacktrack();
        labels.set(k, labelk);
        return currentSolution;
    }

    private boolean lookForward(int i, List<Set<String>> labels, String currRes, Set<Integer> toIgnore) {
        List<Variable> vars = this.getEnv().getVariables();
        int j = 0;
        while (j < vars.size()) {
            if (i != j) {
                boolean labelIsEmpty = true;
                TreeSet label = new TreeSet(labels.get(j));
                for (String res : label) {
                    if (this.isConsistent(vars.get(j), res, vars.get(i), currRes)) {
                        labelIsEmpty = false;
                        continue;
                    }
                    labels.get(j).remove(res);
                }
                if (!toIgnore.contains(j) && labelIsEmpty) {
                    return false;
                }
            }
            ++j;
        }
        j = 0;
        while (j < vars.size()) {
            Set<String> label;
            if (!toIgnore.contains(j) && (label = labels.get(j)).size() == 1) {
                toIgnore.add(j);
                String res = label.iterator().next();
                return this.lookForward(j, labels, res, toIgnore);
            }
            ++j;
        }
        return true;
    }

    @Override
    public boolean hasLabel() {
        return true;
    }
}

