/*
 * Decompiled with CFR 0.152.
 */
package IA_Project.satSolver.solvers;

import IA_Project.satSolver.Environment;
import IA_Project.satSolver.Solution;
import IA_Project.satSolver.Variable;
import IA_Project.satSolver.solvers.Solver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class ForwardCheckSolver
extends Solver {
    public ForwardCheckSolver(Environment env) {
        super(env);
    }

    @Override
    public Solution solve() {
        List<Variable> variables = this.getEnv().getVariables();
        this.clearStepByStepAllocation();
        this.clearStepByStepLabels();
        ArrayList<List<Variable>> domain = new ArrayList<List<Variable>>();
        int i = 0;
        while (i < variables.size()) {
            domain.add(i, new ArrayList());
            int j = 0;
            while (j < variables.get(i).getDomain().getSize()) {
                ((List)domain.get(i)).add(null);
                ++j;
            }
            ++i;
        }
        ArrayList<Set<String>> labels = new ArrayList<Set<String>>();
        int i2 = 0;
        while (i2 < variables.size()) {
            labels.add(i2, new TreeSet<String>(variables.get(i2).getDomain().getResources()));
            ++i2;
        }
        this.addStepAllocation(new ArrayList<String>());
        this.addStepLabels(labels.stream().map(s -> new ArrayList(s)).collect(Collectors.toList()));
        List<String> partialSolution = this.FC_DFS(new ArrayList<String>(), domain, labels);
        HashMap<Variable, String> schedule = new HashMap<Variable, String>();
        if (partialSolution.size() == variables.size()) {
            int i3 = 0;
            while (i3 < variables.size()) {
                schedule.put(variables.get(i3), partialSolution.get(i3));
                ++i3;
            }
        }
        return new Solution(schedule);
    }

    private List<String> FC_DFS(List<String> currentSolution, List<List<Variable>> domain, List<Set<String>> labels) {
        List<Variable> variables = this.getEnv().getVariables();
        int k = currentSolution.size();
        if (k >= variables.size()) {
            return currentSolution;
        }
        this.addEnter();
        int i = 0;
        while (i < variables.get(k).getDomain().getResources().size()) {
            String res = variables.get(k).getDomain().getResources().get(i);
            if (domain.get(k).get(i) == null) {
                currentSolution.add(res);
                this.addInstantiation();
                boolean checkForward = this.checkForward(k, domain, labels, res);
                this.addStepAllocation(new ArrayList<String>(currentSolution));
                labels.get(k).remove(res);
                List<List<String>> l = labels.stream().map(s -> new ArrayList(s)).collect(Collectors.toList());
                this.addStepLabels(l);
                if (checkForward) {
                    this.FC_DFS(currentSolution, domain, labels);
                }
                if (currentSolution.size() >= variables.size()) {
                    return currentSolution;
                }
                currentSolution.remove(k);
                this.restore(k, domain, labels);
            }
            ++i;
        }
        this.addBacktrack();
        labels.set(k, new TreeSet<String>(variables.get(k).getDomain().getResources()));
        return currentSolution;
    }

    private boolean checkForward(int i, List<List<Variable>> domain, List<Set<String>> labels, String currRes) {
        List<Variable> vars = this.getEnv().getVariables();
        int j = i + 1;
        while (j < vars.size()) {
            boolean labelIsEmpty = true;
            int m = 0;
            while (m < vars.get(j).getDomain().getResources().size()) {
                String res = vars.get(j).getDomain().getResources().get(m);
                if (domain.get(j).get(m) == null) {
                    if (this.isConsistent(vars.get(j), res, vars.get(i), currRes)) {
                        labelIsEmpty = false;
                    } else {
                        domain.get(j).set(m, vars.get(i));
                        labels.get(j).remove(res);
                    }
                }
                ++m;
            }
            if (labelIsEmpty) {
                return false;
            }
            ++j;
        }
        return true;
    }

    private void restore(int i, List<List<Variable>> domain, List<Set<String>> labels) {
        List<Variable> vars = this.getEnv().getVariables();
        int j = i + 1;
        while (j < vars.size()) {
            int m = 0;
            while (m < vars.get(j).getDomain().getResources().size()) {
                if (domain.get(j).get(m) == vars.get(i)) {
                    domain.get(j).set(m, null);
                    labels.get(j).add(vars.get(j).getDomain().getResources().get(m));
                }
                ++m;
            }
            ++j;
        }
    }

    @Override
    public boolean hasLabel() {
        return true;
    }
}

