/*
 * Decompiled with CFR 0.152.
 */
package IA_Project.satSolver.solvers;

import IA_Project.satSolver.Environment;
import IA_Project.satSolver.Solution;
import IA_Project.satSolver.Variable;
import IA_Project.satSolver.solvers.Solver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BackTrackSolver
extends Solver {
    public BackTrackSolver(Environment env) {
        super(env);
    }

    @Override
    public Solution solve() {
        List<Variable> variables = this.getEnv().getVariables();
        this.clearStepByStepAllocation();
        this.addStepAllocation(new ArrayList<String>());
        List<String> partialSolution = this.DFS(new ArrayList<String>());
        HashMap<Variable, String> schedule = new HashMap<Variable, String>();
        if (partialSolution.size() == variables.size()) {
            int i = 0;
            while (i < variables.size()) {
                schedule.put(variables.get(i), partialSolution.get(i));
                ++i;
            }
        }
        return new Solution(schedule);
    }

    private List<String> DFS(List<String> currentSolution) {
        List<Variable> variables = this.getEnv().getVariables();
        int k = currentSolution.size();
        if (k >= variables.size()) {
            return currentSolution;
        }
        this.addEnter();
        for (String res : variables.get(k).getDomain().getResources()) {
            boolean consistent = true;
            int i = 0;
            while (i < k) {
                consistent = consistent && this.isConsistent(variables.get(k), res, variables.get(i), currentSolution.get(i));
                ++i;
            }
            if (!consistent) continue;
            currentSolution.add(res);
            this.addInstantiation();
            this.getStepByStepAllocation().add(new ArrayList<String>(currentSolution));
            currentSolution = this.DFS(currentSolution);
            if (currentSolution.size() >= variables.size()) {
                return currentSolution;
            }
            currentSolution.remove(k);
        }
        currentSolution.add("*");
        this.getStepByStepAllocation().add(new ArrayList<String>(currentSolution));
        currentSolution.remove("*");
        this.addBacktrack();
        return currentSolution;
    }

    @Override
    public boolean hasLabel() {
        return false;
    }
}

