/*
 * Decompiled with CFR 0.152.
 */
package IA_Project.satSolver.solvers;

import IA_Project.satSolver.Environment;
import IA_Project.satSolver.Network;
import IA_Project.satSolver.Solution;
import IA_Project.satSolver.Variable;
import IA_Project.satSolver.solvers.Solver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;

public class BackJumpSolver
extends Solver {
    private final TreeSet<Variable> conflictSet_ = new TreeSet((v1, v2) -> this.getEnv().getVariables().indexOf(v1) - this.getEnv().getVariables().indexOf(v2));

    public BackJumpSolver(Environment env) {
        super(env);
    }

    @Override
    public Solution solve() {
        List<Variable> variables = this.getEnv().getVariables();
        this.conflictSet_.clear();
        this.clearStepByStepAllocation();
        this.addStepAllocation(new ArrayList<String>());
        List<String> partialSolution = this.BJ_DFS(new ArrayList<String>());
        HashMap<Variable, String> schedule = new HashMap<Variable, String>();
        if (partialSolution.size() == variables.size()) {
            int i = 0;
            while (i < variables.size()) {
                schedule.put(variables.get(i), partialSolution.get(i));
                ++i;
            }
        }
        return new Solution(schedule);
    }

    private List<String> BJ_DFS(List<String> currentSolution) {
        List<Variable> variables = this.getEnv().getVariables();
        int k = currentSolution.size();
        if (k >= variables.size()) {
            return currentSolution;
        }
        this.addEnter();
        for (String res : variables.get(k).getDomain().getResources()) {
            boolean consistent = true;
            int i = 0;
            while (i < k) {
                consistent = consistent && this.isConsistent(variables.get(k), res, variables.get(i), currentSolution.get(i));
                ++i;
            }
            if (!consistent) continue;
            currentSolution.add(res);
            this.addInstantiation();
            this.addStepAllocation(new ArrayList<String>(currentSolution));
            currentSolution = this.BJ_DFS(currentSolution);
            if (currentSolution.size() >= variables.size() || currentSolution.size() <= k) {
                return currentSolution;
            }
            currentSolution.remove(k);
        }
        currentSolution.add("*");
        this.addStepAllocation(new ArrayList<String>(currentSolution));
        currentSolution.remove("*");
        this.addBacktrack();
        Network net = this.getEnv().getNetwork();
        int i = k - 1;
        while (i >= 0) {
            this.addCheck();
            if (!net.getConstraint(variables.get(i), variables.get(k)).isIndependentWithRessource(currentSolution.get(i))) {
                this.conflictSet_.add(variables.get(i));
            }
            --i;
        }
        if (!this.conflictSet_.isEmpty()) {
            Variable lastVar = this.conflictSet_.last();
            int i2 = variables.indexOf(lastVar) + 1;
            while (i2 < k) {
                currentSolution.remove(currentSolution.size() - 1);
                ++i2;
            }
            this.conflictSet_.remove(lastVar);
        }
        return currentSolution;
    }

    @Override
    public boolean hasLabel() {
        return false;
    }
}

