/*
 * Decompiled with CFR 0.152.
 */
package IA_Project.satSolver.gui;

import IA_Project.satSolver.Environment;
import IA_Project.satSolver.Solution;
import IA_Project.satSolver.Variable;
import IA_Project.satSolver.gui.ControlParametersBean;
import IA_Project.satSolver.gui.EnvironmentCanvas;
import IA_Project.satSolver.gui.InfoPanel;
import IA_Project.satSolver.solvers.BackJumpSolver;
import IA_Project.satSolver.solvers.BackTrackSolver;
import IA_Project.satSolver.solvers.ForwardCheckSolver;
import IA_Project.satSolver.solvers.LookAheadSolver;
import IA_Project.satSolver.solvers.MethodSolving;
import IA_Project.satSolver.solvers.Solver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class Work {
    private Environment environment_ = Environment.Generator.randomEnvironment();
    private Solution solution_ = new Solution();
    private final StringProperty method_ = new SimpleStringProperty();

    public void doSolve(EnvironmentCanvas dessin, InfoPanel result, ControlParametersBean currentBean) {
        result.reInitDetails();
        dessin.clearLabels();
        Solver solver = ((String)this.method_.get()).equals(MethodSolving.BACKTRACK.toString()) ? new BackTrackSolver(this.environment_) : (((String)this.method_.get()).equals(MethodSolving.BACKJUMP.toString()) ? new BackJumpSolver(this.environment_) : (((String)this.method_.get()).equals(MethodSolving.FORWARD_CHECKING.toString()) ? new ForwardCheckSolver(this.environment_) : new LookAheadSolver(this.environment_)));
        this.solution_ = solver.solve();
        this.putStepInfo(result, solver);
        dessin.setSteps(this.generateSolutions(solver.getStepByStepAllocation()));
        if (solver.hasLabel()) {
            dessin.setLabels(solver.getStepByStepLabels());
        }
        if (currentBean.stepByStepProperty().get()) {
            result.nextStep();
            dessin.nextStep();
            result.enableDetailsButton();
        } else {
            result.finalStep();
            dessin.finalStep();
        }
        this.solution_ = new Solution();
    }

    private void putStepInfo(InfoPanel result, Solver solver) {
        List<List<String>> steps = solver.getStepByStepAllocation();
        StringBuilder details = new StringBuilder();
        int i = 0;
        while (i < steps.size()) {
            int j = steps.get(i).size();
            while (j < this.environment_.getVariables().size()) {
                steps.get(i).add("\u00b7 ");
                ++j;
            }
            details.append(String.valueOf(i) + "-  " + steps.get(i) + "\n");
            ++i;
        }
        details.append(" \n");
        details.append(" \n");
        details.append("Number of enters : " + solver.getEntersCount() + "\n");
        details.append("Number of backtracks : " + solver.getBacktracksCount() + "\n");
        details.append("Number of instantiations : " + solver.getInstantiationsCount() + "\n");
        details.append("Number of checks : " + solver.getChecksCount() + "\n");
        result.setStringToken(new StringTokenizer(details.toString(), "\n"));
    }

    private List<Solution> generateSolutions(List<List<String>> steps) {
        ArrayList<Solution> solutions = new ArrayList<Solution>();
        int i = 0;
        while (i < steps.size()) {
            HashMap<Variable, String> schedule = new HashMap<Variable, String>();
            int j = 0;
            while (j < steps.get(i).size()) {
                schedule.put(this.environment_.getVariables().get(j), steps.get(i).get(j));
                ++j;
            }
            solutions.add(new Solution(schedule));
            ++i;
        }
        return solutions;
    }

    public Environment getEnvironment() {
        return this.environment_;
    }

    public StringProperty getMethod() {
        return this.method_;
    }

    protected void generateNewRandomEnvironment() {
        this.environment_ = Environment.Generator.randomEnvironment();
    }

    protected void generateDefaultEnvironment() {
        this.environment_ = Environment.Generator.defaultEnvironment();
    }

    public Solution getSolution() {
        return this.solution_;
    }
}

