/*
 * Decompiled with CFR 0.152.
 */
package IA_Project.satSolver.gui;

import IA_Project.satSolver.gui.ControlParametersBean;
import IA_Project.satSolver.gui.EnvironmentCanvas;
import java.util.StringTokenizer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.layout.GridPane;

public class InfoPanel
extends Parent {
    private static final int NUMBER_OF_LINE_DISPLAYED = 4;
    private static final int NUMBER_FINAL_INFORMATIONS = 6;
    private final ListView<String> resultText_;
    private final ObservableList<String> stepsView_;
    private final Button nextButton_;
    private final Button finishButton_;
    private final BooleanProperty showSteps_;
    private StringTokenizer strTok_;

    public InfoPanel(ControlParametersBean cPB, EnvironmentCanvas canvas) {
        Label presentation = new Label("   Details of the search :");
        this.stepsView_ = FXCollections.observableArrayList();
        this.resultText_ = new ListView(this.stepsView_);
        this.resultText_.editableProperty().set(false);
        this.resultText_.setPrefHeight(96.0);
        this.resultText_.setPrefWidth(550.0);
        this.nextButton_ = new Button("Next step");
        this.nextButton_.setOnMouseClicked(value -> {
            this.nextStep();
            canvas.nextStep();
        });
        this.finishButton_ = new Button("Finish");
        this.finishButton_.setOnMouseClicked(value -> {
            this.finalStep();
            canvas.finalStep();
        });
        this.disableDetailsButton();
        this.showSteps_ = new SimpleBooleanProperty();
        this.showSteps_.bind((ObservableValue)cPB.stepByStepProperty());
        GridPane resultGrid = new GridPane();
        resultGrid.addRow(0, new Node[]{presentation});
        resultGrid.addRow(1, new Node[]{this.resultText_, this.nextButton_, this.finishButton_});
        resultGrid.setVgap(5.0);
        resultGrid.setHgap(30.0);
        this.getChildren().add((Object)resultGrid);
    }

    protected void nextStep() {
        this.stepsView_.add((Object)this.strTok_.nextToken());
        this.resultText_.scrollTo(this.stepsView_.size() - 4);
        if (this.strTok_.countTokens() < 6) {
            this.finalStep();
        }
    }

    protected void finalStep() {
        while (this.strTok_.hasMoreTokens()) {
            this.stepsView_.add((Object)this.strTok_.nextToken());
        }
        this.resultText_.scrollTo(this.stepsView_.size() - 4);
        this.disableDetailsButton();
    }

    public void reInitDetails() {
        this.stepsView_.clear();
    }

    public ObservableList<String> getStepsView() {
        return this.stepsView_;
    }

    public StringTokenizer getStringToken() {
        return this.strTok_;
    }

    public void setStringToken(StringTokenizer strTok) {
        this.strTok_ = strTok;
    }

    protected void enableDetailsButton() {
        this.nextButton_.setDisable(false);
        this.finishButton_.setDisable(false);
    }

    protected void disableDetailsButton() {
        this.nextButton_.setDisable(true);
        this.finishButton_.setDisable(true);
    }
}

