/*
 * Decompiled with CFR 0.152.
 */
package IA_Project.satSolver.gui;

import IA_Project.satSolver.Environment;
import IA_Project.satSolver.Solution;
import IA_Project.satSolver.Variable;
import IA_Project.satSolver.gui.Work;
import java.util.Iterator;
import java.util.List;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;

public class EnvironmentCanvas
extends Canvas {
    private static final int LABEL_Y_SHIFT = 20;
    private static final int LABEL_X_SHIFT = 2;
    private static final Color COLOR_BACKGROUND = Color.WHITE;
    private static final Color COLOR_BORDER = Color.BLACK;
    private static final int WIDTH_BORDER = 3;
    private static final int LEGEND_X_SPACE = 70;
    private static final int LEGEND_OVAL_RADIUS = 15;
    private static final int LEGEND_OVAL_Y_SHIFT = -30;
    private static final int LEGEND_OVAL_X_SHIFT = 35;
    private static final int LEGEND_FONT_Y_SHIFT = -18;
    private static final int LEGEND_FONT_X_SHIFT = 15;
    private static final int TASK_X_SHIFT = 0;
    private static final int TASK_Y_SHIFT = 30;
    private static final int TASK_Y_SPACE = 30;
    private static final int TEXT_Y_SHIFT = 12;
    private static final int TEXT_X_SHIFT = -20;
    private static final Color COLOR_FONT = Color.BLACK;
    private static final Font FONT_NORMAL = Font.font((String)"Courier", (double)12.0);
    private static final Font FONT_ITALIC = Font.font((String)"Courier", (FontPosture)FontPosture.ITALIC, (double)12.0);
    private static final Font FONT_BOLD = Font.font((String)"Courier", (FontWeight)FontWeight.BOLD, (double)12.0);
    private static final Color[] RESOURCES_COLOR = new Color[]{Color.PINK, Color.CYAN, Color.GREEN, Color.RED, Color.MAGENTA, Color.ORANGE};
    private Environment environment_;
    private GraphicsContext graphics_;
    private Solution currentSolution_;
    private Iterator<Solution> stepSolutions_;
    private Iterator<List<List<String>>> stepLabels_;
    private List<List<String>> currentLabels_;
    private boolean hasLabels_ = false;

    public EnvironmentCanvas(int height, int weight, Work work, Solution solution) {
        super((double)height, (double)weight);
        this.environment_ = work.getEnvironment();
        this.graphics_ = this.getGraphicsContext2D();
        this.currentSolution_ = solution;
        this.drawEnv(solution);
    }

    protected void drawEnv(Solution solution) {
        this.currentSolution_ = solution;
        this.graphics_.setFill((Paint)COLOR_BACKGROUND);
        this.graphics_.fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
        this.graphics_.setStroke((Paint)COLOR_BORDER);
        this.graphics_.setLineWidth(3.0);
        this.graphics_.strokeRect(0.0, 0.0, this.getWidth(), this.getHeight());
        this.drawLegend();
        this.drawTasks();
    }

    protected void drawEnv(Solution solution, List<List<String>> labels) {
        this.currentLabels_ = labels;
        this.drawEnv(solution);
    }

    protected void erasedEnv() {
        this.graphics_.clearRect(0.0, 0.0, this.getWidth(), this.getHeight());
    }

    private void drawLegend() {
        List<String> resources = this.environment_.getResources();
        int i = 0;
        while (i < resources.size()) {
            this.graphics_.setFill((Paint)RESOURCES_COLOR[i]);
            this.graphics_.fillOval((double)(35 + 70 * i), this.getHeight() + -30.0, 15.0, 15.0);
            this.graphics_.setFill((Paint)COLOR_FONT);
            this.graphics_.setFont(Font.getDefault());
            this.graphics_.fillText(String.valueOf(resources.get(i)) + " : ", (double)(15 + 70 * i), this.getHeight() + -18.0);
            ++i;
        }
    }

    private void drawTasks() {
        List<Variable> tasks = this.environment_.getVariables();
        int i = 0;
        while (i < tasks.size()) {
            Variable taskI = tasks.get(i);
            if (this.currentSolution_.isExisting()) {
                String resourceI = this.currentSolution_.getSolution().get(taskI);
                if (this.environment_.getResources().indexOf(resourceI) != -1) {
                    this.graphics_.setFill((Paint)RESOURCES_COLOR[this.environment_.getResources().indexOf(resourceI)]);
                    this.graphics_.fillRect((double)(0 + taskI.getBeginTime()), (double)(30 + 60 * taskI.getLine()), (double)(taskI.getEndTime() - taskI.getBeginTime()), 30.0);
                }
            }
            this.graphics_.setStroke((Paint)COLOR_BORDER);
            this.graphics_.setLineWidth(3.0);
            this.graphics_.strokeRect((double)(0 + taskI.getBeginTime()), (double)(30 + 60 * taskI.getLine()), (double)(taskI.getEndTime() - taskI.getBeginTime()), 30.0);
            this.graphics_.setFill((Paint)COLOR_FONT);
            this.graphics_.setFont(FONT_ITALIC);
            int middleX = 0 + taskI.getBeginTime() + (taskI.getEndTime() - taskI.getBeginTime()) / 2;
            int underY = 30 + 60 * taskI.getLine() + 30;
            this.graphics_.fillText("Task" + i, (double)(middleX + -20), (double)(underY + 12));
            this.drawLabels(taskI);
            ++i;
        }
    }

    private void drawLabels(Variable task) {
        Paint oldColor = this.graphics_.getFill();
        Font oldFont = this.graphics_.getFont();
        StringBuilder domainStr = new StringBuilder();
        StringBuilder solutionStr = new StringBuilder();
        StringBuilder labelsStr = new StringBuilder();
        List<String> resources = task.getDomain().getResources();
        int i = 0;
        while (i < resources.size()) {
            String resourceI;
            domainStr.append(resources.get(i));
            if (this.currentSolution_.isExisting() && (resourceI = this.currentSolution_.getSolution().get(task)) != null) {
                if (resourceI.equals(resources.get(i))) {
                    solutionStr.append("_");
                } else {
                    solutionStr.append(" ");
                }
            }
            if (this.hasLabels_) {
                List<String> labelsI = this.currentLabels_.get(this.environment_.getVariables().indexOf(task));
                if (labelsI.contains(resources.get(i))) {
                    labelsStr.append(" ");
                } else {
                    labelsStr.append("/");
                }
            }
            ++i;
        }
        this.graphics_.setFill((Paint)COLOR_FONT);
        this.graphics_.setFont(FONT_NORMAL);
        this.graphics_.fillText(domainStr.toString(), (double)(0 + task.getBeginTime() + 2), (double)(30 + 60 * task.getLine() + 20));
        this.graphics_.fillText(labelsStr.toString(), (double)(0 + task.getBeginTime() + 2), (double)(30 + 60 * task.getLine() + 20));
        this.graphics_.setFont(FONT_BOLD);
        this.graphics_.fillText(solutionStr.toString(), (double)(0 + task.getBeginTime() + 2), (double)(30 + 60 * task.getLine() + 20));
        this.graphics_.setFill(oldColor);
        this.graphics_.setFont(oldFont);
    }

    protected void setSteps(List<Solution> stepSolutions) {
        this.stepSolutions_ = stepSolutions.iterator();
    }

    protected void setEnvironment(Environment env) {
        this.environment_ = env;
    }

    protected void nextStep() {
        if (this.stepSolutions_.hasNext()) {
            if (this.hasLabels_) {
                this.drawEnv(this.stepSolutions_.next(), this.stepLabels_.next());
            } else {
                this.drawEnv(this.stepSolutions_.next());
            }
        }
    }

    protected void finalStep() {
        while (this.stepSolutions_.hasNext()) {
            if (this.hasLabels_) {
                this.drawEnv(this.stepSolutions_.next(), this.stepLabels_.next());
                continue;
            }
            this.drawEnv(this.stepSolutions_.next());
        }
    }

    protected void setLabels(List<List<List<String>>> stepLabels) {
        this.stepLabels_ = stepLabels.iterator();
        this.hasLabels_ = true;
    }

    protected void clearLabels() {
        this.hasLabels_ = false;
    }
}

