/*
 * Decompiled with CFR 0.152.
 */
package IA_Project.satSolver.gui;

import IA_Project.satSolver.gui.ControlParametersBean;
import IA_Project.satSolver.gui.SatSolverApplication;
import IA_Project.satSolver.gui.Work;
import IA_Project.satSolver.solvers.MethodSolving;
import javafx.beans.property.Property;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;

public class ControlPanel
extends Parent {
    private final ControlParametersBean oldBean_ = new ControlParametersBean();
    private final ControlParametersBean newBean_ = new ControlParametersBean();

    public ControlPanel(Work work, SatSolverApplication app) {
        this.oldBean_.methodProperty().bindBidirectional((Property)work.getMethod());
        Button generateRandomButton = new Button("Generate Random Problem");
        generateRandomButton.setTranslateY(-30.0);
        generateRandomButton.setOnMouseClicked(value -> this.generateRandom(work, app));
        Button generateDefaultButton = new Button("Generate Default Problem");
        generateDefaultButton.setTranslateY(-30.0);
        generateDefaultButton.setOnMouseClicked(value -> this.generateDefault(work, app));
        Label method = new Label("Method :");
        method.setTranslateX(10.0);
        ChoiceBox methodButton = new ChoiceBox();
        methodButton.getItems().add(0, (Object)MethodSolving.BACKTRACK.toString());
        methodButton.getItems().add(1, (Object)MethodSolving.BACKJUMP.toString());
        methodButton.getItems().add(2, (Object)MethodSolving.FORWARD_CHECKING.toString());
        methodButton.getItems().add(3, (Object)MethodSolving.LOOKAHEAD.toString());
        methodButton.getSelectionModel().selectFirst();
        methodButton.setTranslateX(-80.0);
        this.newBean_.methodProperty().bindBidirectional((Property)methodButton.valueProperty());
        CheckBox stepChoice = new CheckBox("Step by step execution");
        stepChoice.setTranslateX(10.0);
        stepChoice.selectedProperty().bindBidirectional((Property)this.newBean_.stepByStepProperty());
        Button solveButton = new Button("Solve problem");
        solveButton.setTranslateX(120.0);
        solveButton.setTranslateY(20.0);
        solveButton.setOnMouseClicked(value -> this.solveAction(work, app));
        this.oldBean_.synchronize(this.newBean_);
        GridPane controlGrid = new GridPane();
        controlGrid.addRow(0, new Node[]{generateRandomButton, generateDefaultButton});
        controlGrid.addRow(1, new Node[]{method, methodButton});
        controlGrid.addRow(2, new Node[]{stepChoice});
        controlGrid.addRow(3, new Node[]{solveButton});
        controlGrid.setVgap(25.0);
        controlGrid.setHgap(20.0);
        this.getChildren().add((Object)controlGrid);
    }

    private void generateRandom(Work work, SatSolverApplication app) {
        work.generateNewRandomEnvironment();
        this.reInit(work, app);
    }

    private void generateDefault(Work work, SatSolverApplication app) {
        work.generateDefaultEnvironment();
        this.reInit(work, app);
    }

    private void reInit(Work work, SatSolverApplication app) {
        app.getResult().disableDetailsButton();
        app.getDessin().clearLabels();
        app.getResult().reInitDetails();
        app.getDessin().setEnvironment(work.getEnvironment());
        app.getDessin().drawEnv(work.getSolution());
    }

    private void solveAction(Work work, SatSolverApplication app) {
        this.oldBean_.synchronize(this.newBean_);
        work.doSolve(app.getDessin(), app.getResult(), this.oldBean_);
    }

    public ControlParametersBean getOldBean() {
        return this.oldBean_;
    }
}

