/*
 * Decompiled with CFR 0.152.
 */
package IA_Project.satSolver;

import IA_Project.satSolver.Domain;
import IA_Project.satSolver.Network;
import IA_Project.satSolver.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class Environment {
    private final List<Variable> variables_;
    private final List<String> resources_;
    private final Network network_;

    private Environment(List<Variable> variables, List<String> resources, Network network) {
        this.variables_ = variables;
        this.resources_ = resources;
        this.network_ = network;
    }

    public List<Variable> getVariables() {
        return Collections.unmodifiableList(this.variables_);
    }

    public List<String> getResources() {
        return Collections.unmodifiableList(this.resources_);
    }

    public Network getNetwork() {
        return this.network_;
    }

    /* synthetic */ Environment(List list, List list2, Network network, Environment environment) {
        this(list, list2, network);
    }

    public static class Generator {
        private static final Random RANDOM_GENERATOR = new Random();
        private static final List<String> RESOURCES_NAME = Arrays.asList("a", "b", "c", "d", "e", "f");
        private static final int T_MAX = 595;
        private static final int MAX_LINES = 5;
        private static final int DELAY_MIN = 2;
        private static final int DELAY_MAX = 100;
        private static final int TASK_LENGTH_MIN = 45;
        private static final int TASK_LENGTH_MAX = 125;

        public static Environment defaultEnvironment() {
            List<String> liste_ressources = Arrays.asList("a", "b", "c", "d", "e", "f");
            Domain dC = new Domain(Arrays.asList("c"));
            Domain dE = new Domain(Arrays.asList("e"));
            Domain dAE = new Domain(Arrays.asList("a", "e"));
            Domain dBE = new Domain(Arrays.asList("b", "e"));
            Domain dABE = new Domain(Arrays.asList("a", "b", "e"));
            Domain dACF = new Domain(Arrays.asList("a", "c", "f"));
            Domain dADF = new Domain(Arrays.asList("a", "d", "f"));
            Domain dCDE = new Domain(Arrays.asList("c", "d", "e"));
            Domain dCEF = new Domain(Arrays.asList("c", "e", "f"));
            Domain dABCD = new Domain(Arrays.asList("a", "b", "c", "d"));
            Domain dABCE = new Domain(Arrays.asList("a", "b", "c", "e"));
            Domain dABDE = new Domain(Arrays.asList("a", "b", "d", "e"));
            Domain dACDE = new Domain(Arrays.asList("a", "c", "d", "e"));
            Domain dBCDE = new Domain(Arrays.asList("b", "c", "d", "e"));
            ArrayList<Variable> liste_variables = new ArrayList<Variable>();
            liste_variables.add(new Variable(dE, 0, 85, 195, "1"));
            liste_variables.add(new Variable(dE, 0, 250, 360, "2"));
            liste_variables.add(new Variable(dBE, 0, 365, 470, "3"));
            liste_variables.add(new Variable(dCEF, 0, 505, 555, "4"));
            liste_variables.add(new Variable(dCDE, 1, 20, 125, "5"));
            liste_variables.add(new Variable(dBCDE, 1, 190, 240, "6"));
            liste_variables.add(new Variable(dABCE, 1, 280, 360, "7"));
            liste_variables.add(new Variable(dC, 1, 400, 460, "8"));
            liste_variables.add(new Variable(dABCD, 2, 65, 145, "9"));
            liste_variables.add(new Variable(dADF, 2, 180, 265, "10"));
            liste_variables.add(new Variable(dACF, 2, 365, 425, "11"));
            liste_variables.add(new Variable(dADF, 2, 500, 545, "12"));
            liste_variables.add(new Variable(dABE, 3, 50, 130, "13"));
            liste_variables.add(new Variable(dABCE, 3, 210, 340, "14"));
            liste_variables.add(new Variable(dC, 3, 344, 415, "15"));
            liste_variables.add(new Variable(dBCDE, 3, 430, 490, "16"));
            liste_variables.add(new Variable(dABDE, 4, 35, 105, "17"));
            liste_variables.add(new Variable(dAE, 4, 190, 290, "18"));
            liste_variables.add(new Variable(dACDE, 4, 375, 430, "19"));
            Network network = new Network(liste_variables);
            return new Environment(liste_variables, liste_ressources, network, null);
        }

        public static Environment randomEnvironment() {
            ArrayList<Variable> tasks = new ArrayList<Variable>();
            int line = 0;
            int taskNumber = 1;
            while (line < 5) {
                int t1 = 0;
                do {
                    int sizeOfTask;
                    int delayBetweenTask;
                    int t0;
                    if ((t1 = (t0 = t1 + (delayBetweenTask = RANDOM_GENERATOR.nextInt(99) + 2)) + (sizeOfTask = RANDOM_GENERATOR.nextInt(81) + 45)) < 595) {
                        Domain domain = new Domain(Generator.generateResources());
                        String name = "Task " + taskNumber;
                        Variable task = new Variable(domain, line, t0, t1, name);
                        tasks.add(task);
                        ++taskNumber;
                        continue;
                    }
                    ++line;
                } while (t1 < 595);
            }
            Network net = new Network(tasks);
            return new Environment(tasks, RESOURCES_NAME, net, null);
        }

        private static List<String> generateResources() {
            ArrayList<String> resourcesList = new ArrayList<String>();
            int mask = RANDOM_GENERATOR.nextInt((1 << RESOURCES_NAME.size()) - 1) + 1;
            int i = 0;
            while (i < RESOURCES_NAME.size()) {
                if (mask % 2 != 0) {
                    resourcesList.add(RESOURCES_NAME.get(i));
                }
                mask /= 2;
                ++i;
            }
            return resourcesList;
        }
    }
}

