/*
 * Decompiled with CFR 0.152.
 */
package IA_Project.satSolver;

import IA_Project.satSolver.Variable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Constraint {
    private final Variable var1_;
    private final Variable var2_;
    private final List<List<Boolean>> constraintMatrix_;

    public Constraint(Variable var1, Variable var2) {
        this.var1_ = var1;
        this.var2_ = var2;
        this.constraintMatrix_ = new ArrayList<List<Boolean>>();
        int i = 0;
        while (i < this.var1_.getDomain().getSize()) {
            this.constraintMatrix_.add(i, new ArrayList());
            int j = 0;
            while (j < this.var2_.getDomain().getSize()) {
                this.constraintMatrix_.get(i).add(j, true);
                ++j;
            }
            ++i;
        }
        this.setMatrixConstraints();
    }

    public Variable getFirstVariable() {
        return this.var1_;
    }

    public Variable getSecondVariable() {
        return this.var2_;
    }

    public List<List<Boolean>> getConstraintMatrix() {
        return Collections.unmodifiableList(this.constraintMatrix_);
    }

    public Boolean getResourceConstraint(String res1, String res2) {
        int x = this.var1_.getDomain().getResources().indexOf(res1);
        int y = this.var2_.getDomain().getResources().indexOf(res2);
        return this.constraintMatrix_.get(x).get(y);
    }

    private void setMatrixConstraints() {
        if (this.timeIntersect(this.var1_, this.var2_)) {
            List<String> resources1 = this.var1_.getDomain().getResources();
            List<String> resources2 = this.var2_.getDomain().getResources();
            int i = 0;
            while (i < resources1.size()) {
                int j = 0;
                while (j < resources2.size()) {
                    if (resources1.get(i).equals(resources2.get(j))) {
                        this.constraintMatrix_.get(i).set(j, false);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private boolean timeIntersect(Variable var1, Variable var2) {
        int begin1 = var1.getBeginTime();
        int begin2 = var2.getBeginTime();
        int end1 = var1.getEndTime();
        int end2 = var2.getEndTime();
        return begin1 >= begin2 && begin1 <= end2 || end1 >= begin2 && end1 <= end2 || begin2 >= begin1 && begin2 <= end1 || end2 >= begin1 && end2 <= end1;
    }

    public boolean isIndependentWithRessource(String res) {
        return !this.constraintMatrix_.get(this.var1_.getDomain().getResources().indexOf(res)).contains(false);
    }
}

