#include <unistd.h>

#include <iomanip>
#include <iostream>
#include <memory>
#include <sstream>
#include <string>

#include <openssl/evp.h>
#include <grpcpp/grpcpp.h>

#include "gen/hash_service.grpc.pb.h"


using grpc::Server;
using grpc::ServerBuilder;
using grpc::ServerContext;
using grpc::Status;
using grpc::StatusCode;
using hashservice::Sha256Req;
using hashservice::Sha256Resp;
using hashservice::HashService;


class HashServiceImpl: public HashService::Service {
private:
    bool calcSha256(const std::string &data, std::string &hash) {
        bool fail = true;

        EVP_MD_CTX *ctx = NULL;
        char       *dig = NULL;

        std::stringstream ss;

        printf("recving %lu bytes\n", data.size());

        if ((ctx = EVP_MD_CTX_new()) == NULL)
            goto out;

        if (EVP_DigestInit_ex(ctx, EVP_sha256(), NULL) != 1)
            goto out;

        if (EVP_DigestUpdate(ctx, data.data(), data.size()) != 1)
            goto out;

        if ((dig = (char *)(OPENSSL_malloc(EVP_MD_size(EVP_sha256())))) == NULL)
            goto out;

        unsigned int len;

        if (EVP_DigestFinal_ex(ctx, (uint8_t *)(dig), &len) != 1)
            goto out;

        for (auto i = 0u; i < len; i++)
            ss << std::hex << std::setw(2) << std::setfill('0') << (int)(dig[i] & 0xff);

        hash = ss.str();
        fail = false;

    out:
        if (ctx)
            EVP_MD_CTX_free(ctx);
        if (dig)
            OPENSSL_free(dig);

        return fail;
    }

public:
    Status Sha256(ServerContext* context,
               const Sha256Req* request,
               Sha256Resp* response) override {
        std::string hash;

        if (calcSha256(request->data(), hash))
            return Status(StatusCode::RESOURCE_EXHAUSTED, "");

        response->set_hash(hash);

        return Status::OK;
    }
};


int main(int argc, char** argv) {
    auto raw_addr = getenv("HASH_SERVICE_ADDR");

    std::string addr(raw_addr ?: "0.0.0.0:20000");

    HashServiceImpl service;
    ServerBuilder   builder;

    builder.AddListeningPort(addr, grpc::InsecureServerCredentials());
    builder.RegisterService(&service);

    std::unique_ptr<Server> server(builder.BuildAndStart());

    server->Wait();

    return 0;
}
