#!/usr/bin/python

import os
import sys

# pip install grpcio
import grpc
import random

import gen.hash_service_pb2
import gen.hash_service_pb2_grpc


class FileService:
    def __init__(self, addr):
        self.chan = grpc.insecure_channel(addr)
        self.stub = gen.hash_service_pb2_grpc.HashServiceStub(self.chan)

    def sha(self, data):
        return self.stub.Sha256(gen.hash_service_pb2.Sha256Req(data = data)).hash

    def run(self):
        try:
            while True:
                data = random.randbytes(random.randint(1, 1024))

                print(f'sending {len(data)} bytes')
                hash = self.sha(data)

                input(hash)

        except KeyboardInterrupt:
            print("Exiting client...")

        finally:
            self.chan.close()

if __name__ == '__main__':
    client = FileService(os.environ.get('HASH_SERVICE_ADDR', '127.0.0.1:20000'))
    client.run()
