import asyncio
import time
import random
import hashlib

UNIQUE_REQS = 10000
hash_arr = [_ for _ in range(UNIQUE_REQS)]

class Request:
    def __init__(self, id, payload, type):
        self.id = id
        self.payload = payload
        self.type = type

def get_new_request():
    choice = random.randint(0, 5)
    if choice == 0:
        id = random.randint(0, UNIQUE_REQS - 1)
        payload = f'Payload for request {id}'*int(1e8)
        type = random.randint(0, 1)
        req = Request(id = id, payload = payload, type = type)
        return req
    else:
        return None

def save_file(req):
    with open('output.txt', 'a') as file:
        file.write(f'Request {req.id}: {req.payload}\n')
    print(f'Finished saving request {req.id} to file')
    return

def sha(req):
    hash_arr[req.id] = hashlib.sha256(req.payload.encode()).hexdigest()
    print(f'Finished hashing request {req.id}')
    return

def handle_req(req):
    if req.type == 0:
        save_file(req)
    elif req.type == 1:
        sha(req)
    return

def event_loop(num_reqs):
    reqs = 0
    while True:
        req = get_new_request()
        if req is not None:
            handle_req(req)
            reqs += 1
        else:
            time.sleep(0.1)
        if reqs == num_reqs:
            break
    print(f'Finished serving {reqs} requests')
    return

if __name__ == '__main__':
    random.seed(21)
    tstart = time.time()
    event_loop(10)
    tend = time.time()
    print(f'Time taken: {tend - tstart:.2f} seconds')