import asyncio
import time
import random

async def hello(index):
    await asyncio.sleep(random.uniform(1, 5))
    print(f'Hello, world! {index}')
    
def main():
    tstart = time.time()
    loop = asyncio.get_event_loop()
    tasks = [hello(i) for i in range(1, 5)]
    loop.run_until_complete(asyncio.gather(*tasks))
    tend = time.time()
    print(f'Time taken: {tend - tstart:.2f} seconds')

if __name__ == '__main__':
    main()