
#include <stdlib.h>
#include <iostream>
#include <iomanip>
#include "utility.h"
#include "cuda_runtime.h"
using namespace std;

void printDeviceProperties(int device) {
    cudaDeviceProp prop;
    cudaGetDeviceProperties(&prop, device);

    printf("=== CUDA Device %d: %s ===\n", device, prop.name);
    printf("Compute capability: %d.%d\n", prop.major, prop.minor);
    printf("Clock rate: %d kHz\n", prop.clockRate);
    printf("Total global memory: %zu bytes\n", prop.totalGlobalMem);
    printf("Shared memory per block: %zu bytes\n", prop.sharedMemPerBlock);
    printf("Registers per block: %d\n", prop.regsPerBlock);
    printf("Warp size: %d\n", prop.warpSize);
    printf("Max threads per block: %d\n", prop.maxThreadsPerBlock);
    printf("Max blocks per multiprocessor: %d\n", prop.maxBlocksPerMultiProcessor);
    printf("Max threads dim: (%d, %d, %d)\n", prop.maxThreadsDim[0], prop.maxThreadsDim[1], prop.maxThreadsDim[2]);
    printf("Max grid size: (%d, %d, %d)\n", prop.maxGridSize[0], prop.maxGridSize[1], prop.maxGridSize[2]);
    printf("Multiprocessor count (SMs): %d\n", prop.multiProcessorCount);
    printf("L2 cache size: %d bytes\n", prop.l2CacheSize);
    printf("==============================\n");
}

int main(int argc, const char **argv) {

    // Get some stats
    printDeviceProperties(0);

    return 0;
}