#!/bin/bash
#SBATCH --chdir /scratch/izar/ayanchak
#SBATCH --partition=gpu
#SBATCH --qos=cs-302
#SBATCH --gres=gpu:1
#SBATCH --nodes=1
#SBATCH --time=1:0:0
#SBATCH --ntasks-per-node=1
#SBATCH --cpus-per-task=1
#SBATCH --mem 2G
#SBATCH --account cs-302

module load gcc cuda

echo STARTING AT `date`

g++ hello.cpp -o hello
nvcc hello.cu -o hello_cu
nvcc hello2.cu -o hello_cu2
nvcc hello3.cu -o hello_cu3
nvcc prop.cu -o prop

echo "hello.cpp"
./hello 100000000
echo ""

echo "hello.cu"
./hello_cu 100000000
echo ""

echo "hello2.cu"
./hello_cu2 100000000
echo ""

echo "hello3.cu"
./hello_cu3 100000000
echo ""

echo "prop.cu"
./prop
echo ""

rm hello hello_cu hello_cu2 hello_cu3 prop

echo FINISHED at `date`