object Quads:

  type Point = (Int, Int)

  def inRange(p: Point, minP: Point, maxP: Point): Boolean = 
    minP._1 <= p._1 && p._1 < maxP._1 &&
    minP._2 <= p._2 && p._2 < maxP._2

  sealed abstract class QuadTree
  case class Empty() extends QuadTree
  case class Leaf(p: List[Point]) extends QuadTree
  case class Quad(center: Point,
                  nw: QuadTree, ne: QuadTree, 
                  sw: QuadTree, se: QuadTree) extends QuadTree

  extension(t: QuadTree)
    def valid(minP: Point, maxP: Point): Boolean = 
      t match
        case Empty() => true
        case Leaf(ps) => ps.forall(inRange(_, minP, maxP))
        case Quad(c, nw, ne, sw, se) => 
          // east increases ._1, south increases ._2
          // minP  |     
          //   nw  |  ne
          // ------c---------
          //   sw  |  se
          //       |     maxP
          inRange(c, minP, maxP) &&
          nw.valid(minP, c) && se.valid(c, maxP) &&
          ne.valid((c._1, minP._2), (maxP._1, c._2)) &&
          sw.valid((minP._1, c._2), (c._1, maxP._2))        

end Quads