enum List[T]:
  case Nil()
  case Cons(head: T, tail: List[T])

  def map[U](f: T => U): List[U] =
    this match
      case Nil()            => Nil()
      case Cons(head, tail) => Cons(f(head), tail.map(f))

  def size: BigInt = {
    this match
      case Nil()         => BigInt(0)
      case Cons(_, tail) => BigInt(1) + tail.size
  }.ensuring(_ >= 0)
