//> using dep "org.scalacheck::scalacheck:1.18.1"
import stainless.lang.StaticChecks.*
import stainless.annotation.*
import stainless.collection.*
import stainless.lang.*

object mSortExample {
  def isSorted(list: List[Int]): Boolean = {
    decreases(list)
    list match 
      case Cons(x1, tail @ Cons(x2, _)) => x1 <= x2 && isSorted(tail)
      case _ => true
  }

  def merge(l1: List[Int], l2: List[Int]): List[Int] = {
    require(isSorted(l1) && isSorted(l2))
    decreases(l1.length + l2.length)
    (l1, l2) match {
      case (Cons(x, xs), Cons(y, ys)) =>
        if (x <= y) Cons(x, merge(xs, l2))
        else Cons(y, merge(l1, ys))
      case _ => l1 ++ l2
    }
  }.ensuring { res =>
    isSorted(res) &&
    res.length == l1.length + l2.length &&
    res.content == l1.content ++ l2.content // sets are faster than bags
  }

  def split(list: List[Int]): (List[Int], List[Int]) = {    
    decreases(list)
    list match {
      case Cons(x1, Cons(x2, xs)) =>
        val (s1, s2) = split(xs)
        (Cons(x1, s1), Cons(x2, s2))
      case _ => (Nil[Int](), list)
    }
  }.ensuring { res =>
   res._1.size + res._2.size == list.size &&
   res._1.content ++ res._2.content == list.content
  }
  
  def mSort(list: List[Int]): List[Int] = {
    list match
      case Cons(h1, Cons(h2, rest)) =>
        val (s1, s2) = split(rest)
        merge(mSort(s1), mSort(s2))
      case _ => list
  }
//  .ensuring { res => 
//    isSorted(res) && res.length <= list.length && 
//    res.content.subsetOf(list.content) 
//  }
 
  def mSortProperty(lst: List[Int]): Unit = {
  }.ensuring(_ => mSort(lst) != Cons(123456, Nil()))
  // [Warning ] Found counter-example:
  // [Warning ]   lst: List[Int] -> Cons[Int](123456, Nil[Int]())

}
