import stainless.lang.*
object Find {
  def existsIn(a: Array[Int], from: Int, to: Int, x: Int): Boolean = 
    require(0 <= from && from <= to && to <= a.size)
    decreases(to - from)
    !(from == to) &&
    ((a(from) == x) || existsIn(a, from, to - 1, x))

  def find(a: Array[Int], from: Int, to: Int, x: Int): Int = {
    require(0 <= from && from <= to && to <= a.size)
    var i = from
    (while i < to && a(i) != x do    
      decreases(to - i)
      i = i + 1
    ).invariant(from <= i && i <= to && !existsIn(a, from, i, x))
    if i < to then i
    else -1
  }.ensuring(res =>
    (from <= res && res < to && a(res) == x) ||
    (res == -1 && !existsIn(a, from, to, x)))
}
