import stainless.collection._
import stainless.lang._

def appendIndex[T](l1: List[T], l2: List[T], i: BigInt): Unit = {
  require(0 <= i && i < l1.size + l2.size)
  decreases(l1)
    l1 match
      case Cons(x,xs) if (i > 0) => appendIndex[T](xs, l2, i - 1)
      case _ => ()
}.ensuring(_ => (l1 ++ l2).apply(i) ==
                (if i < l1.size then l1(i) else l2(i - l1.size)))
