## Subresource Integrity

If you are loading Highlight.js via CDN you may wish to use [Subresource Integrity](https://developer.mozilla.org/en-US/docs/Web/Security/Subresource_Integrity) to guarantee that you are using a legimitate build of the library.

To do this you simply need to add the `integrity` attribute for each JavaScript file you download via CDN. These digests are used by the browser to confirm the files downloaded have not been modified.

```html
<script
  src="//cdnjs.cloudflare.com/ajax/libs/highlight.js/11.9.0/highlight.min.js"
  integrity="sha384-xBsHBR6BS/LSlO3cOyY2D/4KkmaHjlNn3NnXUMFFc14HLZD7vwVgS3+6U/WkHAra"></script>
<!-- including any other grammars you might need to load -->
<script
  src="//cdnjs.cloudflare.com/ajax/libs/highlight.js/11.9.0/languages/go.min.js"
  integrity="sha384-WmGkHEmwSI19EhTfO1nrSk3RziUQKRWg3vO0Ur3VYZjWvJRdRnX4/scQg+S2w1fI"></script>
```

The full list of digests for every file can be found below.

### Digests

```
sha384-4fBir7jJHF8vQZyZ+AljsNm5cbq86jL9AITYmJdNK7zrCGDgQ+KSzDM9UdqYQehp /es/languages/scala.js
sha384-5KqbJwOue0VrSIbMNJrkRcBOzNPBxlGPbrTdH/biCYczeCVi0Ethcg+fr1RXfH8i /es/languages/scala.min.js
sha384-fTEZwIYHuPF/IPt/9cYmUOxedtwV1lgf7s8YR0WCalv3x1IyOOs9x2fU9MmatJ9e /languages/scala.js
sha384-tbWlb460xfE9lNi4sNjNnZ4Btfos1He7bWO+9UmtNq4TwJ7F7nX8gaR0e6sVJsUk /languages/scala.min.js
sha384-Wvw/Zyt9EIffbl2b1w/9hbZUcOjvbJZsn9lkI8ORuPSxA+BgdbS9udumLgpFgGL9 /highlight.js
sha384-Kj7sdyv4ZPpSZvLp1hXx+F/QMqHt/0r6wXSs5lUsoT1eMEOK+UQkYb6DIHIRVzs2 /highlight.min.js
```

