package codebreaking

class MasterMindScoreSuite extends TimedSuite(1):
  import MasterMind.*
  import MasterMind.Color.*

  test("MasterMind.score(List(), List()) (2pts)"):
    assertEquals(MasterMind.score(List(), List()), Score(0, 0))

  test("MasterMind.score(List(Brown, Green), List(Brown, Pink)) (2pts)"):
    assertEquals(
      MasterMind.score(List(Brown, Green), List(Brown, Pink)),
      Score(1, 0)
    )

  test("MasterMind.score(List(Brown, Green, Blue), List(Pink, Blue, Brown)) (2pts)"):
    assertEquals(
      MasterMind.score(List(Brown, Green, Blue), List(Pink, Blue, Brown)),
      Score(0, 2)
    )

  test(
    "MasterMind.score(List(Purple, Purple, Purple, Purple), List(Purple, Red, Purple, Red)) (2pts)"
  ):
    assertEquals(
      MasterMind.score(
        List(Purple, Purple, Purple, Purple),
        List(Purple, Red, Purple, Red)
      ),
      Score(2, 0)
    )

  test(
    "MasterMind.score(List(Pink, Red, Pink, Red, Pink, Red), List(Red, Pink, Red, Pink, Blue, Blue)) (2pts)"
  ):
    assertEquals(
      MasterMind.score(
        List(Pink, Red, Pink, Red, Pink, Red),
        List(Red, Pink, Red, Pink, Blue, Blue)
      ),
      Score(0, 4)
    )

  test(
    "MasterMind.score(List(Brown, Green, Blue, Blue, White, Brown), List(Pink, Blue, Brown, Pink, Blue, Brown)) (2pts)"
  ):
    assertEquals(
      MasterMind.score(
        List(Brown, Green, Blue, Blue, White, Brown),
        List(Pink, Blue, Brown, Pink, Blue, Brown)
      ),
      Score(1, 3)
    )

  test(
    "MasterMind.score(List(Pink, Red, Red, Pink, Pink, Red), List(Red, Pink, Red, Pink, Blue, Blue)) (2pts)"
  ):
    assertEquals(
      MasterMind.score(
        List(Pink, Red, Red, Pink, Pink, Red),
        List(Red, Pink, Red, Pink, Blue, Blue)
      ),
      Score(2, 2)
    )

  test("MasterMind.score: length 9 (2pts)"):
    assertEquals(
      MasterMind.score(
        List(Red, Purple, Brown, Blue, White, Pink, Green, Carmine, Fuchsia),
        List(Carmine, Purple, Blue, Green, Brown, Fuchsia, Pink, White, Red)
      ),
      Score(1, 8)
    )

  // format: off
  test("MasterMind.score: length 40 (2pts)"):
    assertEquals(
      MasterMind.score(
        List(
          Blue, White, Fuchsia, Blue, Fuchsia, Pink, White, Brown,
          Green, White, Carmine, Pink, Fuchsia, Brown, Blue, White,
          Fuchsia, Red, Blue, Red, Carmine, Pink, Green, Green,
          Fuchsia, White, Carmine, Brown, Blue, Pink, Fuchsia, Pink,
          Carmine, Green, White, Green, Blue, Fuchsia, Carmine, Fuchsia
        ),
        List(
          White, Fuchsia, Fuchsia, White, Fuchsia, Brown, Green, Brown,
          Blue, Brown, Pink, Carmine, Carmine, Pink, Carmine, Brown,
          Carmine, White, Brown, Red, Blue, Green, Carmine, Pink,
          Fuchsia, Purple, Carmine, Red, White, Purple, Brown, Pink,
          Brown, Purple, Pink, Red, Purple, Blue, Pink, Fuchsia
        )
      ),
      Score(8, 21)
    )

  test("MasterMind.score: length 60 (2pts)"):
    assertEquals(
      MasterMind.score(
        List(
          Purple, Fuchsia, Red, Fuchsia, Brown, White, Carmine, Purple,
          Red, Blue, White, Pink, Red, Green, Pink, Carmine,
          Purple, Green, Blue, Blue, Red, Purple, White, Purple,
          Fuchsia, Purple, Fuchsia, Blue, Carmine, Purple, Green, White,
          Pink, Pink, Purple, Fuchsia, Green, Brown, Green, Red,
          Pink, Brown, Blue, Blue, Green, Red, Brown, Blue,
          Carmine, Carmine, Brown, White, Fuchsia, Blue, Brown, Green,
          Blue, Fuchsia, Carmine, Pink
        ),
        List(
          White, Green, Blue, Green, Blue, Blue, Pink, Green,
          Purple, Green, Blue, Blue, Fuchsia, Purple, Blue, Fuchsia,
          Fuchsia, Green, Pink, Purple, Pink, Brown, Pink, Red,
          White, Fuchsia, Brown, Fuchsia, Red, Purple, Brown, Pink,
          Fuchsia, Carmine, Red, Purple, Pink, Brown, Brown, White,
          Blue, Fuchsia, Purple, Purple, Fuchsia, Brown, Purple, Red,
          Purple, Carmine, Green, Carmine, Purple, Pink, White, Green,
          Red, Pink, Carmine, Pink
        )
      ),
      Score(7, 47)
    )
  // format: on
