package codebreaking

object MasterMind:
  enum Color:
    case Red, Purple, Brown, Blue, White, Pink, Green, Carmine, Fuchsia

  type Word = List[Color]
  case class Score(redKeys: Int, whiteKeys: Int)
  val allColors: List[Color] = Color.values.toList

  class Game(wordLength: Int) extends Puzzle[Word, Score]:

    def score(guess: Word, secret: Word): Score =
      require(guess.length == wordLength, f"Guess must have length $wordLength.")
      require(secret.length == wordLength, f"Secret must have length $wordLength.")
      ???

    def guess(previousGuesses: List[ScoredGuess[Word, Score]]): GuessResult[Word] =
      require(
        previousGuesses.forall(_._1.length == wordLength),
        f"Previous guesses must have length $wordLength"
      )
      ???

