package codebreaking

enum GuessResult[+Word]:
  case StillGuessing(nextGuess: Word)
  case FoundSolution(solution: Word)
  case NoSolution extends GuessResult[Nothing]
import GuessResult.*

case class ScoredGuess[Word, Score](guess: Word, score: Score)

abstract class Puzzle[Word, Score]:
  def score(guess: Word, secret: Word): Score
  def guess(previousGuesses: List[ScoredGuess[Word, Score]]): GuessResult[Word]

