#include <iostream>
#include <vector>
#include <string>
using namespace std;

/* 
 CONSTAT : c'est un bon début, mais :
   1) manque de structuration des données  : identifier les CONCEPTS clés
   2) manque de modularisation (fonctions) : intentifier les TRAITEMENTS clés
   3) Généricité : on ne peut faire que de la fondue ; pourquoi pas autre chose ? facile ?

mineurs/plus tard:
   4) rendre la saisie plus robuste : do-while
   5) simplifier/améliorer l'affichage
*/


typedef double Quantite;

struct Ingredient
{
  string nom;
  string unite;
  Quantite qtt;
};

struct Recette {
  unsigned int nb_personnes;
  string nom;
  vector<Ingredient> ingredients; // liste et quantités
};

int main()
{
  Recette fondue(
                 { .nb_personnes = 4,     // nombre de personnes pour la recette de base
                   .nom = "fondue fribourgeoise",
                   
                   // Pour faire une fondue fribourgeoise pour 4 personnes il faut : 
                   .ingredients = {
                     { "Vacherin fribourgeois", "gr", 800.0 },  // 800gr de  Vacherin fribourgeois
                     { "eau",                   "dl",   2.0 },  // 2dl d'eau
                     { "ail",            "gousse(s)",   2.0 },  // 2 gousses d'ail
                     { "pain",                  "gr", 400.0 }   // 400 gr de pain
                   }
                 });
   
  /* On supposera pour cet exercice que l'utilisateur ne saisit que
   * des valeurs strictement positives mais nous pourrions faire mieux.
   */
  cout << "Entrez le nombre de personnes conviées à la fondue : ";
  int nb_convives;
  cin >> nb_convives;
 
  // Mise à jour des quantités en fonction du nombre de convives :
  double ratio(nb_convives);    // Notez le 'double' ici...
  ratio /= fondue.nb_personnes; // ... pour éviter une division entière.

  for (auto& ingredient : fondue.ingredients) { // ATTENTION ! n'oubliez pas le & ici !
    ingredient.qtt *= ratio;
  }

  fondue.nb_personnes = nb_convives; // ne pas oublier ça (nouveau) !!
 
  cout << "Pour faire une " << fondue.nom << " pour " << fondue.nb_personnes << " personne(s), " << endl;
  cout << "il vous faut : " << endl;
  for (auto const& ingredient : fondue.ingredients) {
    cout << " - " << ingredient.qtt
         << " " << ingredient.unite
         << " de " << ingredient.nom
         << endl;
  }
 
  return 0;
}

