#include <iostream>
#include <vector>
using namespace std;

constexpr size_t default_width(3);

// ======================================================================
void affiche_synchro(vector<double> const& v,
                     vector<double> const& w)
{
  size_t offset(0);
  cout << "# signal ; moyenne mobile" << endl;
  if (w.size() < v.size()) {
    offset = v.size() - w.size();
    for (size_t i(0); i < offset; ++i) {
      cout << v[i] << endl;
    }
  }
  for (size_t i(offset); i < v.size(); ++i) {
    cout << v[i] << '\t' << w[i-offset] << endl;
  }
}

/* ======================================================================
 * Calcule le signal filtré par moyenne mobile sur fenêtre de taille T_c.
 */
vector<double> filtre_moyenne_mobile(vector<double> const& x,
                                     size_t K = default_width)
{
  // rajouté juste pour s'assurer qu'on ne fait pas de bêtises
  if ((K == 0)
      or (K > x.size())) // s'assurer qu'on a assez de points
    return vector<double>(); 

  // début fait en cours
  vector<double> x_chapeau(x.size() - K + 1);

  for (size_t n(0); n < x_chapeau.size(); ++n) {
    // double somme(0.0);
    // x_chapeau est déjà init à 0.0

    // version avec boucle adaptée
    for (size_t m(n); m <= n + (K-1); ++m) {
      x_chapeau[n] += x[m];
    }

    /*
    // version avec index/accès adapté.
    // ATTENTION ! Un size_t NE peut PAS être négatif !!
    for (int m(n - K + 1); m <= int(n); ++m) {
      x_chapeau[n] += x[m + (K-1)];
    }
    */

    x_chapeau[n] /= K;
  }
 
  return x_chapeau;
}

// ======================================================================
int main()
{
  vector<double> temperatures( { 15.1, 14.8, 13.7, 12.6, 13.8, 14.1,
                                 14.5, 14.8, 15.0, 15.1, 15.5         } );

  affiche_synchro(temperatures, filtre_moyenne_mobile(temperatures) );

  return 0;
}
