from miniproject import *
import time


# 3pt
def simple_blur(img_gray: Image, ksize: int) -> Image:
    """Blurs the image in 2 passes to allow for efficient downscaling"""
    return ...  # TODO


# Provided (do not modify)
def downscale(img_gray: Image, factor: int) -> Image:
    """Downscales the image using an integer area downsampling method."""
    blured = simple_blur(img_gray, factor)
    return copy_image(blured[::factor, ::factor])


# 2pt
def find_most_likely_positions(
    img_gray: Image, pattern_gray: Image, top_n: int
) -> list[Position]:
    """Similar to find_similar_pattern_position, but returns the top n positions with lowest difference"""
    return ...  # TODO


# 3pt
def faster_search(
    img_gray: Image, pattern_gray: Image, factor: int, top_n: int
) -> Position:
    """Similar to find_similar_pattern_position but optimized to search faster using downscaling"""
    return ...  # TODO


# 0pt (not graded)
def faster_highlight(
    img_gray: Image,
    pattern_gray: Image,
    value: int,
    linewidth: int,
    factor: int,
    top_n: int,
) -> Image:
    """Highlights the most similar pattern (found using faster_search) by drawing a rectangle arround it"""
    # Note: this function is not graded because it should be the
    # same as highlight_similar_pattern but using faster_search
    # instead of find_similar_pattern_position.
    return ...  # TODO


def blur_test(img_path: str, factor: int):
    print(f"---- Bluring/Downscaling {img_path} ----")

    ### - Make folders for the results
    img_name, img_ext = split_name_ext(img_path)

    output_folder = f"{img_name}/"
    os.makedirs(output_folder, exist_ok=True)

    ### - Load the source image and convert to grayscale
    img_gray = to_grayscale(load_image(img_path))

    ### - Blur the image
    # blured = simple_blur(img_gray, factor)
    # save_image(blured, output_folder + f"4_blured_x{factor}" + img_ext)

    ### - Downscale the image
    # downscaled = downscale(img_gray, factor)
    # save_image(downscaled, output_folder + f"5_downscaled_x{factor}" + img_ext)


def faster_highlight_test(
    img_path: str, pattern_path: str, factor: int, top_n=4
) -> None:
    print(
        f"---- Highlighting pattern {pattern_path} on image {img_path} but faster ----"
    )

    ### - Make folders for the results
    img_name, img_ext = split_name_ext(img_path)
    pat_name, _ = split_name_ext(os.path.basename(pattern_path))

    output_folder = f"{img_name}/"
    os.makedirs(output_folder, exist_ok=True)

    ### - Load the source images and convert to grayscale
    img_gray = to_grayscale(load_image(img_path))
    pat_gray = to_grayscale(load_image(pattern_path))

    ### - Find and highlight pattern
    # print("started search...")
    # start = time.time()
    # out = faster_highlight(img_gray, pat_gray, 255, 3, factor, top_n)
    # print(
    #     f"search with {factor}x downscale and top{top_n} took: {time.time() - start}s"
    # )
    # save_image(
    #     out, output_folder + f"6_fastsearch_{factor}x_top{top_n}_{pat_name}" + img_ext
    # )


if __name__ == "__main__":
    # Insérez du code de test ici si vous le souhaitez
    blur_test("imgs/parking.jpg", 4)
    blur_test("imgs/sunrise.jpg", 10)

    faster_highlight_test("imgs/parking.jpg", "imgs/car.jpg", 4)
    faster_highlight_test(
        "imgs/tablet.jpg", "imgs/glyph.jpg", 3
    )  # Note: this one will not find the position of the glyph.
    faster_highlight_test(
        "imgs/tablet.jpg", "imgs/glyph.jpg", 3, 100
    )  # this one will find it
