#include <iostream>
#include <fstream>
#include <string>
#include <vector>
#include <iomanip>
using namespace std;

// ======================================================================
struct Decos {
  bool fleche;
  bool boules;
  bool guirlandes;
};

// --------------------------------------------------
typedef unsigned int uint;  // ou size_t ?

// --------------------------------------------------
struct Trapeze { // ou typedef

  // largeur          )
  // angle du trapèze )  ==> hauteur ?

  uint taille;
};

// --------------------------------------------------
struct Tronc {
  uint largeur;
  uint hauteur;
};

// --------------------------------------------------
struct Sapin {
  // nombre d'étages : nombre de trapèzes
  vector<Trapeze> corps;
  
  // taille(s?) tronc
  Tronc tronc;
  
  // caractère du sapin
  char dessin_corps;
  
  // caractère du tronc
  char dessin_pied;

  // décoration(s?)
  Decos decorations;
};

// ======================================================================
string demander_nom()
{
  cout << "Entrez un nom de fichier où écrire : ";
  string nom;
  cin >> nom; // ou getline() si blanc(s) dans le nom de fichier
  return nom;
}

// ======================================================================
bool ouvrir(ofstream& fichier)
// retour : vrai si fichier OK
{
  fichier.open( demander_nom() );
  return not fichier.fail();

  /* amélioration : afficher un message d'erreur :

  const bool erreur = fichier.fail();
  if (erreur) {
    cerr << "Error: cannot open \"" << nom << '"' << endl;
  }
  return not erreur;
  */

}

// ======================================================================
void dessine_fleche   (ofstream& fichier, uint offset);
void dessine_rectangle(ofstream& fichier, uint offset, uint height, uint width
                       , char c);
void dessine_corps    (ofstream& fichier, vector<Trapeze> corps
                       , char c);

void dessiner(ofstream& fichier, Sapin const& sapin)
{
  // 1) dessine la tete
  if (sapin.decorations.fleche) {
    dessine_fleche(fichier, sapin.corps.back().taille);
  }

  // 2) dessine le corps (version simple, sans décoration)
  dessine_corps(fichier, sapin.corps, sapin.dessin_corps);

  // 3) dessine le tronc
  dessine_rectangle(fichier, sapin.corps.back().taille - sapin.tronc.largeur / 2,
                    sapin.tronc.hauteur, sapin.tronc.largeur,
                    sapin.dessin_pied);
}

// ======================================================================
// outils de dessin

// --------------------------------------------------
void place(ofstream& fichier, int offset, char c, bool endline = true)
/* « place » (= dessine) un caractère à un offset donné ;
   passe éventuellement à la ligne suivante.
  Cette fonction évite le copié-collé entre dessine_ligne() et dessine_deco().
*/
{
  fichier << setfill(' ') << setw(offset+1) << c;
  if (endline) fichier << endl;
}

// --------------------------------------------------
void dessine_ligne(ofstream& fichier, uint offset, uint taille, char a_dessiner)
/* dessine une ligne de taille fois « a_dessiner »,
   à partir d'un offset donné.
*/
{
  if (taille > 0) {
    place(fichier, offset, a_dessiner, false);
    if (taille > 1) {
      fichier << setfill(a_dessiner) << setw(taille-1) << a_dessiner;
    }
    fichier << endl;
  }
}

// --------------------------------------------------
void dessine_trapeze(ofstream& fichier, uint offset, Trapeze const& t, char c)
{
  for(uint i(1); i <= t.taille; ++i) {
    dessine_ligne(fichier, offset + t.taille - i, 2*i+1, c);
  }
}

// --------------------------------------------------
void dessine_corps(ofstream& fichier, vector<Trapeze> corps, char c)
{
  place(fichier, corps.back().taille, c); // la tête

  for (auto t : corps) {
    dessine_trapeze(fichier, corps.back().taille - t.taille, t, c);
  }
}

// --------------------------------------------------
void dessine_rectangle(ofstream& fichier, uint offset, uint height, uint width,
                       char c)
{
  for(uint i(1); i <= height; ++i) {
    dessine_ligne(fichier, offset, width, c);
  }
}

// --------------------------------------------------
void dessine_fleche(ofstream& fichier, uint offset)
{
  place(fichier, offset, '^');
  place(fichier, offset, '|');
}

// ======================================================================
int main()
{
  ofstream fichier;

  if (ouvrir(fichier)) {

    dessiner(fichier,
             {
               { {3}, {5}, {9} },
               { 6, 3 },
               '*', '#',
               { true, false, false },
             }

             );

    fichier.close();
  }
    
  return 0;
}
