#include <iostream>
#include <fstream>
#include <string>
#include <vector>
#include <iomanip>

// nombres au hasard
#include <functional> // pour bind()
#include <random>

using namespace std;

// ======================================================================
struct Decos {
  bool fleche;
  
  bool boules;
  char dessin_boule;
  double proba_boule;

  bool guirlandes;
};

// --------------------------------------------------
typedef unsigned int uint;  // ou size_t ?

// --------------------------------------------------
struct Trapeze { // ou typedef

  // largeur          )
  // angle du trapèze )  ==> hauteur ?

  uint taille;
};

// --------------------------------------------------
struct Tronc {
  uint largeur;
  uint hauteur;
};

// --------------------------------------------------
struct Sapin {
  // nombre d'étages : nombre de trapèzes
  vector<Trapeze> corps;
  
  // taille(s?) tronc
  Tronc tronc;
  
  // caractère du sapin
  char dessin_corps;
  
  // caractère du tronc
  char dessin_pied;

  // décoration(s?)
  Decos decorations;
};

// ======================================================================
bool tirage(double proba_true)
{
  random_device rd;          // utilisé ici pour la graine
  unsigned int graine(rd()); // par exemple, ou sinon de votre choix

  // choix du générateur et initialisation (graine)
  default_random_engine generateur(graine);

  uniform_real_distribution<double> distribution(0.0, 1.0);
  function<double()> draw(bind(distribution, generateur));

  if (draw() < proba_true) return true;
  return false;
}

// ======================================================================
string demander_nom()
{
  cout << "Entrez un nom de fichier où écrire : ";
  string nom;
  cin >> nom; // ou getline() si blanc(s) dans le nom de fichier
  return nom;
}

// ======================================================================
bool ouvrir(ofstream& fichier)
// retour : vrai si fichier OK
{
  fichier.open( demander_nom() );
  return not fichier.fail();

  /* amélioration : afficher un message d'erreur :

  const bool erreur = fichier.fail();
  if (erreur) {
    cerr << "Error: cannot open \"" << nom << '"' << endl;
  }
  return not erreur;
  */

}

// ======================================================================
void dessine_fleche   (ofstream& fichier, uint offset);
void dessine_rectangle(ofstream& fichier, uint offset, uint height, uint width
                       , char c);
void dessine_corps    (ofstream& fichier, vector<Trapeze> corps
                       , char c, char random = 0, double proba = 0.0);

void dessiner(ofstream& fichier, Sapin const& sapin)
{
  // 1) dessine la tete
  if (sapin.decorations.fleche) {
    dessine_fleche(fichier, sapin.corps.back().taille);
  }

  // 2) dessine le corps (version avancées, avec boules)
  dessine_corps(fichier, sapin.corps, sapin.dessin_corps,
                sapin.decorations.dessin_boule, sapin.decorations.proba_boule);

  // 3) dessine le tronc
  dessine_rectangle(fichier, sapin.corps.back().taille - sapin.tronc.largeur / 2,
                    sapin.tronc.hauteur, sapin.tronc.largeur,
                    sapin.dessin_pied);
}

// ======================================================================
// outils de dessin

// --------------------------------------------------
void place(ofstream& fichier, int offset, char c, bool endline = true)
/* « place » (= dessine) un caractère à un offset donné ;
   passe éventuellement à la ligne suivante.
  Cette fonction évite le copié-collé entre dessine_ligne() et dessine_deco().
*/
{
  fichier << setfill(' ') << setw(offset+1) << c;
  if (endline) fichier << endl;
}

// --------------------------------------------------
void dessine_ligne(ofstream& fichier, uint offset, uint taille, char a_dessiner,
                   char random = 0, double proba = 0.0)
/* dessine une ligne de taille fois « a_dessiner »,
   à partir d'un offset donné.
   Version avancée : perturbe parfois la ligne avec une caractère de « bruit »
   (utilisé pour dessiner les boules).
*/
{
  if ((random == 0) or (proba <= 0.0) or (proba > 1.0)) {
    // version de base, sans caractère au hasard
    if (taille > 0) {
      place(fichier, offset, a_dessiner, false);
      if (taille > 1) {
        fichier << setfill(a_dessiner) << setw(taille-1) << a_dessiner;
      }
    }
  } else {
    // quelques de caractères au hasard
    char c(a_dessiner);
    if (tirage(proba)) c = random;
    place(fichier, offset, a_dessiner, false);
    // on ne peut plus utiliser setfill ici à cause des char au hasard
    for (uint i(2); i <= taille; ++i) {
      c = tirage(proba) ? random : a_dessiner;
      fichier << c;
    }
  }
  fichier << endl;
}

// --------------------------------------------------
void dessine_trapeze(ofstream& fichier, uint offset, Trapeze const& t, char c,
                   char random = 0, double proba = 0.0)
{
  for(uint i(1); i <= t.taille; ++i) {
    dessine_ligne(fichier, offset + t.taille - i, 2*i+1, c, random, proba);
  }
}

// --------------------------------------------------
void dessine_corps(ofstream& fichier, vector<Trapeze> corps, char c,
                   char random, double proba)
{
  place(fichier, corps.back().taille, c); // la tête

  for (auto t : corps) {
    dessine_trapeze(fichier, corps.back().taille - t.taille, t, c,
                    random, proba);
  }
}

// --------------------------------------------------
void dessine_rectangle(ofstream& fichier, uint offset, uint height, uint width,
                       char c)
{
  for(uint i(1); i <= height; ++i) {
    dessine_ligne(fichier, offset, width, c);
  }
}

// --------------------------------------------------
void dessine_fleche(ofstream& fichier, uint offset)
{
  place(fichier, offset, '^');
  place(fichier, offset, '|');
}

// ======================================================================
int main()
{
  ofstream fichier;

  if (ouvrir(fichier)) {

    dessiner(fichier,
             {
               { {3}, {5}, {9} },
               { 6, 3 },
               '*', '#',
               { true, true, 'O', 0.05, false },
             }

             );

    fichier.close();
  }
    
  return 0;
}
