#include <iostream>
#include <vector>
using namespace std;

constexpr size_t K_par_defaut(3);

// ======================================================================
void affiche_synchro(vector<double> const& v,
                     vector<double> const& w)
{
  size_t offset(0);
  cout << "# signal ; moyenne mobile" << endl;
  if (w.size() < v.size()) {
    offset = v.size() - w.size();
    for (size_t i(0); i < offset; ++i) {
      cout << v[i] << endl;
    }
  }
  for (size_t i(offset); i < v.size(); ++i) {
    cout << v[i] << '\t' << w[i-offset] << endl;
  }
}

/* ======================================================================
 * Calcule le signal filtré par moyenne mobile sur fenêtre de taille T_c.
 */
vector<double> filtre_moyenne_mobile(vector<double> X, size_t K = 3)
{
  vector<double> X_chapeau;

  for (size_t n(K-1); n < X.size(); ++n) {
    
    double somme(0.0);
    for (size_t m(n-K+1); m <= n; ++m) {
      somme += X[m];
    }

    somme /= K;
    
    X_chapeau.push_back(somme);
  }
  
  return X_chapeau;
}

// ======================================================================
int main()
{
  vector<double> temperatures( { 15.1, 14.8, 13.7, 12.6, 13.8, 14.1,
                                 14.5, 14.8, 15.0, 15.1, 15.5         } );

  affiche_synchro(temperatures, filtre_moyenne_mobile(temperatures) );

  return 0;
}
