#include <iostream>
using namespace std;

// ======================================================================
int augmente(int a, int b = 1)
{
  return a + b;
}

char augmente(char c)
{
  // Si c est une minuscule
  if ((c >= 'a') and (c <= 'z')) {
    // majuscule(x) est à x ce que 'A' est à 'a'
    return c + 'A' - 'a'; // ou aussi :  'A' + (c - 'a')
  }

  return c;
}

// ==== TESTS ===========================================================
void test(char a)
{
  cout << '\'' << a << "' --> '"
       << augmente(a)
       << '\'' << endl;
}

// ----------------------------------------------------------------------
void test(int a)
{
  cout << a << " (tout seul) --> "
       << augmente(a)
       << endl;
}

// ----------------------------------------------------------------------
void test(int a, int b)
{
  cout << a << " et " << b << " --> "
       << augmente(a, b)
       << endl;
}

// ----------------------------------------------------------------------
int main()
{
  test(4, 5);
  test(4);
  test(0);
  test(1, 0);

  test('a');
  test('i');
  test('z');
  test('A');
  test(' ');
  test('?');
  test('\n');
  
  return 0;
}
