#include <iostream>
using namespace std;

// ===============================================================
int somme_chiffres(int n)
{
  int retour(0);

  // on boucle sur les chiffres du nombre
  while (n > 0) {
    retour += n % 10; // on a ajoute le dernier chiffre à la somme
    n /= 10; // on enlève le dernier chiffre au nombre traité
  }
  
  return retour;
}

// ===============================================================
int produit_chiffres(int n)
{
  int retour(1);

  while (n > 0) {
    retour *= n % 10;
    n /= 10;
  }
  
  return retour;
}

// ===============================================================
bool verifie_la_propriete(int n)
{ return somme_chiffres(n) == produit_chiffres(n); }

// ===============================================================
int main()
{

  /// TESTS
  for (auto n : { 178, 1, 10, 123 } ){
    cout << "pour n = " << n << " on a la somme   : " << somme_chiffres(n)   << endl;
    cout << "pour n = " << n << " on a le produit : " << produit_chiffres(n) << endl;
  }
  
  /// PROGRAMME PRINCIPAL
  
  constexpr int a_trouver(20);
  int trouve(0);  /// OU : bool tout_trouve(false);
  
  int candidat(10);

  while (trouve < a_trouver) { /// OU : while( not tout:trouve )

    if (verifie_la_propriete(candidat)) {
      ++trouve; // on en a trouvé un de plus
      cout << candidat << endl;
    }

    ++candidat; // on passe au candidat suivant
  }
  
  return 0;
}
