#ifndef __UTIL_H__

#define __UTIL_H__

#define max(x, y) ((x) >= (y) ? (x) : (y))
#define min(x, y) ((x) >= (y) ? (y) : (x))
#define abs(x) ((x) < 0 ? -(x) : (x))

#include "engine.h"
#include "state.h"

int log_init(char *file_name);
void log_stop();
void log_info(const char *message);
void merge_piece(struct board *board, const struct piece *piece, int piece_r, int piece_c);
void destroy_matrix(int **mat, int r);
struct piece **load_pieces(const char *filename, int *num_pieces);
int init_state(struct state *state, int argc, char **argv);
void destroy_state(struct state *state);

#endif
