#ifndef __ENGINE_H__
#define __ENGINE_H__

struct board
{
    int **data;
    int n_rows;
    int n_cols;
};

struct piece
{
    int **shape;
    int size;
};

void rotate_piece(
    const struct piece *piece,
    struct piece *rotated);

int is_valid_position(
    const struct board *board,
    const struct piece *piece,
    int piece_r,
    int piece_c);

int drop_piece(
    const struct board *board,
    const struct piece *piece,
    int piece_r,
    int piece_c);

int clear_lines(
    struct board *board);

int position_score(
    const struct board *board,
    const struct piece *piece,
    int piece_r,
    int piece_c);

int find_best_position(
    const struct board *board,
    const struct piece *pieces,
    int *best_c,
    int *best_rot);

#endif
