#include "display.h"

#define ASPECT_RATIO 2
#define MAX_COLORS 6

#define START_R 5
#define START_C 5

#define max(x, y) ((x) >= (y) ? (x) : (y))
#define min(x, y) ((x) < (y) ? (x) : (y))

void init_colors()
{
    init_pair(1, COLOR_BLACK, COLOR_GREEN);
    init_pair(2, COLOR_BLACK, COLOR_BLUE);
    init_pair(3, COLOR_BLACK, COLOR_MAGENTA);
    init_pair(4, COLOR_BLACK, COLOR_RED);
    init_pair(5, COLOR_BLACK, COLOR_YELLOW);
    init_pair(6, COLOR_BLACK, COLOR_CYAN);
    init_pair(7, COLOR_BLACK, COLOR_WHITE);
}

void init_display(
    struct state *state)
{
    initscr();
    curs_set(0);
    clear();
    noecho();
    cbreak(); /* Line buffering disabled. pass on everything */

    state->menu_win = newwin(
        state->board.n_rows + 2,
        state->board.n_cols * ASPECT_RATIO + 2,
        START_R,
        START_C);
    keypad(state->menu_win, TRUE);
    nodelay(state->menu_win, TRUE);
    mvprintw(0, 0, "Use arrow keys to move and rotate pieces.");
    mvprintw(1, 0, "Press space to bring down the piece.");
    mvprintw(2, 0, "Score: %6d", state->score);

    start_color();
    init_colors();

    refresh();
}

void print_board(
    const struct state *state)
{
    int x, y, i, j;

    x = 1;
    y = 1;
    for (i = 0; i < state->board.n_rows; ++i)
        for (j = 0; j < state->board.n_cols; ++j)
        {
            int val = state->board.data[i][j];
            if (val > 0)
            {
                wattron(state->menu_win, COLOR_PAIR(val % MAX_COLORS + 1));
                mvwprintw(state->menu_win, y + i, x + ASPECT_RATIO * j, "  ", val);
                wattroff(state->menu_win, COLOR_PAIR(val % MAX_COLORS + 1));
            }
            else
            {
                wattron(state->menu_win, COLOR_PAIR(0));
                mvwprintw(state->menu_win, y + i, x + ASPECT_RATIO * j, "  ");
                wattroff(state->menu_win, COLOR_PAIR(0));
            }
        }

if (state->current_piece >= 0)
    {
        for (i = 0; i < state->pieces[state->current_piece][state->piece_rot].size; i++)
        {
            for (j = 0; j < state->pieces[state->current_piece][state->piece_rot].size; j++)
            {
                int val = state->pieces[state->current_piece][state->piece_rot].shape[i][j];
                int bly = y + state->piece_r + i, blx = x + ASPECT_RATIO * (state->piece_c + j);
                if (val &&
                    x <= blx &&
                    blx < x + state->board.n_cols * ASPECT_RATIO &&
                    y <= bly &&
                    bly < y + state->board.n_rows)
                {
                    wattron(state->menu_win, COLOR_PAIR(val % MAX_COLORS + 1));
                    mvwprintw(state->menu_win, bly, blx, "  ");
                    wattroff(state->menu_win, COLOR_PAIR(val % MAX_COLORS + 1));
                }
            }
        }
    }
    box(state->menu_win, 0, 0);
    wrefresh(state->menu_win);
}
