#ifndef __TEST_UTILS_H__
#define __TEST_UTILS_H__

#include "engine.h"

int **allocate_matrix(int r, int c);
void free_matrix(int **mat, int r);
void display_matrix(int **mat, int r, int c);

void display_piece(const struct piece *target);
void display_board(const struct board *target);

struct piece clone_piece(const struct piece *piece);

struct piece piece_from_array(const int *mat, int size);
struct piece piece_from_stdin();

struct board board_from_array(const int *mat, int n_rows, int n_cols);
struct board board_from_stdin();

int piece_equals(const struct piece *piece1, const struct piece *piece2);

void free_piece(struct piece *target);
void free_board(struct board *target);
#endif
